/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.zoning;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.component.PlanitComponent;
import org.goplanit.demands.Demands;
import org.goplanit.network.virtual.VirtualNetworkImpl;
import org.goplanit.od.demand.OdDemands;
import org.goplanit.utils.graph.GraphEntityDeepCopyMapper;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.id.ManagedIdDeepCopyMapper;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.Modes;
import org.goplanit.utils.network.virtual.CentroidVertex;
import org.goplanit.utils.network.virtual.CentroidVertexUtils;
import org.goplanit.utils.network.virtual.VirtualNetwork;
import org.goplanit.utils.time.TimePeriod;
import org.goplanit.utils.zoning.Centroid;
import org.goplanit.utils.zoning.ConnectoidUtils;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.utils.zoning.DirectedConnectoids;
import org.goplanit.utils.zoning.OdZone;
import org.goplanit.utils.zoning.OdZones;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.TransferZoneGroup;
import org.goplanit.utils.zoning.TransferZoneGroupUtils;
import org.goplanit.utils.zoning.TransferZoneGroups;
import org.goplanit.utils.zoning.TransferZones;
import org.goplanit.utils.zoning.UndirectedConnectoid;
import org.goplanit.utils.zoning.UndirectedConnectoids;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.utils.zoning.modifier.ZoningModifier;
import org.goplanit.zoning.DirectedConnectoidsImpl;
import org.goplanit.zoning.OdZonesImpl;
import org.goplanit.zoning.TransferZoneGroupsImpl;
import org.goplanit.zoning.TransferZonesImpl;
import org.goplanit.zoning.UndirectedConnectoidsImpl;
import org.goplanit.zoning.modifier.ZoningModifierImpl;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class Zoning
extends PlanitComponent<Zoning>
implements Serializable {
    private static final long serialVersionUID = -2986366471146628179L;
    private static final Logger LOGGER = Logger.getLogger(Zoning.class.getCanonicalName());
    protected CoordinateReferenceSystem crs;
    protected final VirtualNetwork virtualNetwork;
    protected final ZoningModifier zoningModifier;
    protected final UndirectedConnectoids odConnectoids;
    protected final DirectedConnectoids transferConnectoids;
    protected final OdZones odZones;
    protected final TransferZones transferZones;
    protected final TransferZoneGroups transferZoneGroups;

    public Zoning(IdGroupingToken groupId, IdGroupingToken virtualNetworkGroupId) {
        super(groupId, Zoning.class);
        this.virtualNetwork = new VirtualNetworkImpl(virtualNetworkGroupId);
        this.odConnectoids = new UndirectedConnectoidsImpl(virtualNetworkGroupId);
        this.transferConnectoids = new DirectedConnectoidsImpl(virtualNetworkGroupId);
        this.odZones = new OdZonesImpl(virtualNetworkGroupId);
        this.transferZones = new TransferZonesImpl(virtualNetworkGroupId);
        this.transferZoneGroups = new TransferZoneGroupsImpl(virtualNetworkGroupId);
        this.zoningModifier = new ZoningModifierImpl(this);
    }

    public Zoning(Zoning other, boolean deepCopy, ManagedIdDeepCopyMapper<UndirectedConnectoid> undirConnectoidMapper, ManagedIdDeepCopyMapper<DirectedConnectoid> dirConnectoidMapper, ManagedIdDeepCopyMapper<OdZone> odZoneMapper, ManagedIdDeepCopyMapper<TransferZone> transferZoneMapper, ManagedIdDeepCopyMapper<TransferZoneGroup> transferZoneGroupMapper) {
        super(other, deepCopy);
        this.zoningModifier = new ZoningModifierImpl(this);
        if (deepCopy) {
            this.odConnectoids = other.odConnectoids.deepCloneWithMapping(undirConnectoidMapper);
            this.transferConnectoids = other.transferConnectoids.deepCloneWithMapping(dirConnectoidMapper);
            this.odZones = other.odZones.deepCloneWithMapping(odZoneMapper);
            this.transferZones = other.transferZones.deepCloneWithMapping(transferZoneMapper);
            this.transferZoneGroups = other.transferZoneGroups.deepCloneWithMapping(transferZoneGroupMapper);
            if (odZoneMapper != null) {
                ConnectoidUtils.updateAccessZoneMapping((Iterable)this.odConnectoids, z -> (OdZone)odZoneMapper.getMapping(z), (boolean)true);
            }
            if (transferZoneMapper != null) {
                ConnectoidUtils.updateAccessZoneMapping((Iterable)this.transferConnectoids, z -> (TransferZone)transferZoneMapper.getMapping(z), (boolean)true);
                TransferZoneGroupUtils.updateTransferZoneMapping((Iterable)this.transferZoneGroups, z -> (TransferZone)transferZoneMapper.getMapping(z), (boolean)true);
            }
            GraphEntityDeepCopyMapper connectoidEdgeMapper = new GraphEntityDeepCopyMapper();
            GraphEntityDeepCopyMapper connectoidEdgeSegmentMapper = new GraphEntityDeepCopyMapper();
            GraphEntityDeepCopyMapper centroidVertexMapper = new GraphEntityDeepCopyMapper();
            this.virtualNetwork = other.virtualNetwork.deepCloneWithMapping(connectoidEdgeMapper, connectoidEdgeSegmentMapper, centroidVertexMapper);
            Map<Centroid, Centroid> centroidMapper = centroidVertexMapper.stream().collect(Collectors.toMap(entry -> ((CentroidVertex)entry.getKey()).getParent(), entry -> ((CentroidVertex)entry.getValue()).getParent()));
            CentroidVertexUtils.updateCentroidVertexCentroidMapping((Iterable)this.virtualNetwork.getCentroidVertices(), originalCentroid -> (Centroid)centroidMapper.get(originalCentroid), (boolean)true);
        } else {
            this.odConnectoids = other.odConnectoids.shallowClone();
            this.transferConnectoids = other.transferConnectoids.shallowClone();
            this.odZones = other.odZones.shallowClone();
            this.transferZones = other.transferZones.shallowClone();
            this.transferZoneGroups = other.transferZoneGroups.shallowClone();
            this.virtualNetwork = other.virtualNetwork.shallowClone();
        }
    }

    public void logInfo(String prefix) {
        LOGGER.info(String.format("%s XML id %s (external id: %s) ", prefix, this.getXmlId(), this.getExternalId()));
        LOGGER.info(String.format("%s #od zones: %d (#centroids: %d)", prefix, this.odZones.size(), this.odZones.getNumberOfCentroids()));
        LOGGER.info(String.format("%s #od connectoids: %d", prefix, this.odConnectoids.size()));
        if (!this.transferZones.isEmpty()) {
            LOGGER.info(String.format("%s #transfer connectoids: %d", prefix, this.transferConnectoids.size()));
            LOGGER.info(String.format("%s #transfer zones: %d", prefix, this.transferZones.size(), this.transferZones.getNumberOfCentroids()));
            LOGGER.info(String.format("%s #transfer zone groups: %d", prefix, this.transferZoneGroups.size()));
        }
    }

    public VirtualNetwork getVirtualNetwork() {
        return this.virtualNetwork;
    }

    public boolean isCompatibleWithDemands(Demands demands, Modes modes) {
        int nofZones = this.odZones.size();
        for (Mode mode : modes) {
            Iterator iterator = demands.timePeriods.iterator();
            while (iterator.hasNext()) {
                TimePeriod timePeriod = (TimePeriod)iterator.next();
                OdDemands odDemandsForModeTime = demands.get(mode, timePeriod);
                if (odDemandsForModeTime == null || nofZones == odDemandsForModeTime.getNumberOfOdZones()) continue;
                return false;
            }
        }
        return true;
    }

    public Zone getZone(long id) {
        Zone zone = (Zone)this.odZones.get(id);
        if (zone == null) {
            zone = (Zone)this.transferZones.get(id);
        }
        return zone;
    }

    public OdZones getOdZones() {
        return this.odZones;
    }

    public TransferZones getTransferZones() {
        return this.transferZones;
    }

    public TransferZoneGroups getTransferZoneGroups() {
        return this.transferZoneGroups;
    }

    public UndirectedConnectoids getOdConnectoids() {
        return this.odConnectoids;
    }

    public DirectedConnectoids getTransferConnectoids() {
        return this.transferConnectoids;
    }

    public long getNumberOfCentroids() {
        return this.odZones.getNumberOfCentroids() + this.transferZones.getNumberOfCentroids();
    }

    public long getNumberOfConnectoids() {
        return this.odConnectoids.size() + this.transferConnectoids.size();
    }

    public ZoningModifier getZoningModifier() {
        return this.zoningModifier;
    }

    public Zoning shallowClone() {
        return new Zoning(this, false, null, null, null, null, null);
    }

    public Zoning deepClone() {
        return new Zoning(this, true, (ManagedIdDeepCopyMapper<UndirectedConnectoid>)new ManagedIdDeepCopyMapper(), (ManagedIdDeepCopyMapper<DirectedConnectoid>)new ManagedIdDeepCopyMapper(), (ManagedIdDeepCopyMapper<OdZone>)new ManagedIdDeepCopyMapper(), (ManagedIdDeepCopyMapper<TransferZone>)new ManagedIdDeepCopyMapper(), (ManagedIdDeepCopyMapper<TransferZoneGroup>)new ManagedIdDeepCopyMapper());
    }

    @Override
    public void reset() {
        this.virtualNetwork.reset();
        this.odConnectoids.reset();
        this.odZones.reset();
        this.transferConnectoids.reset();
        this.odConnectoids.reset();
        this.transferZoneGroups.reset();
        this.transferZones.reset();
    }

    @Override
    public Map<String, String> collectSettingsAsKeyValueMap() {
        return null;
    }

    public boolean hasOdZones() {
        return !this.getOdZones().isEmpty();
    }

    public boolean hasTransferZones() {
        return !this.getTransferZones().isEmpty();
    }

    public boolean hasTransferConnectoids() {
        return !this.getTransferConnectoids().isEmpty();
    }

    public boolean hasOdConnectoids() {
        return !this.getOdConnectoids().isEmpty();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }
}

