/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.zoning;

import java.util.HashMap;
import java.util.Map;
import org.goplanit.utils.id.ExternalIdAbleImpl;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.CloneUtils;
import org.goplanit.utils.zoning.Centroid;
import org.goplanit.utils.zoning.Zone;
import org.locationtech.jts.geom.Geometry;

public abstract class ZoneImpl
extends ExternalIdAbleImpl
implements Zone {
    protected String name;
    protected Map<String, Object> inputProperties = null;
    protected Centroid centroid;
    protected Geometry geometry = null;

    protected static long generateZoneId(IdGroupingToken groupId) {
        return IdGenerator.generateId((IdGroupingToken)groupId, (Class)Zone.ZONE_ID_CLASS);
    }

    protected void setCentroid(Centroid centroid) {
        this.centroid = centroid;
    }

    protected void setId(long id) {
        super.setId(id);
    }

    public ZoneImpl(IdGroupingToken tokenId) {
        super(ZoneImpl.generateZoneId(tokenId));
    }

    public ZoneImpl(ZoneImpl other, boolean deepCopy) {
        super((ExternalIdAbleImpl)other);
        this.name = other.name;
        this.centroid = deepCopy ? other.centroid.deepClone() : other.centroid.shallowClone();
        this.centroid.setParentZone((Zone)this);
        this.geometry = deepCopy ? other.getGeometry().copy() : other.geometry;
        this.inputProperties = new HashMap<String, Object>();
        if (other.inputProperties != null) {
            if (deepCopy) {
                CloneUtils.deepCloneFromTo(other.inputProperties, this.inputProperties);
            } else {
                this.inputProperties.putAll(other.inputProperties);
            }
        }
    }

    public Centroid getCentroid() {
        return this.centroid;
    }

    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addInputProperty(String key, Object value) {
        if (this.inputProperties == null) {
            this.inputProperties = new HashMap<String, Object>();
        }
        this.inputProperties.put(key, value);
    }

    public Object getInputProperty(String key) {
        if (this.inputProperties != null) {
            return this.inputProperties.get(key);
        }
        return null;
    }

    public long recreateManagedIds(IdGroupingToken tokenId) {
        long newId = ZoneImpl.generateZoneId(tokenId);
        this.setId(newId);
        this.getCentroid().recreateManagedIds(tokenId);
        return newId;
    }

    public abstract ZoneImpl shallowClone();

    public abstract ZoneImpl deepClone();

    public String toString() {
        return String.format("id: %d, Xmlid: %s name:%s", this.getId(), this.getXmlId(), this.getName());
    }
}

