/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.zoning;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.TransferZoneGroup;
import org.goplanit.utils.zoning.TransferZoneType;
import org.goplanit.zoning.ZoneImpl;

public class TransferZoneImpl
extends ZoneImpl
implements TransferZone {
    private long transferZoneId;
    private TransferZoneType type = DEFAULT_TYPE;
    Set<TransferZoneGroup> transferZoneGroups = null;
    List<String> platformNames;

    protected static long generateTransferZoneId(IdGroupingToken tokenId) {
        return IdGenerator.generateId((IdGroupingToken)tokenId, (Class)TransferZone.TRANSFER_ZONE_ID_CLASS);
    }

    protected void setTransferZoneId(long transferZoneId) {
        this.transferZoneId = transferZoneId;
    }

    public TransferZoneImpl(IdGroupingToken tokenId) {
        super(tokenId);
        this.setTransferZoneId(TransferZoneImpl.generateTransferZoneId(tokenId));
        this.platformNames = null;
    }

    public TransferZoneImpl(TransferZoneImpl other, boolean deepCopy) {
        super(other, deepCopy);
        this.transferZoneId = other.transferZoneId;
        this.type = other.type;
        if (other.hasTransferZoneGroup()) {
            this.transferZoneGroups = new HashSet<TransferZoneGroup>(other.getTransferZoneGroups());
        }
        if (other.hasPlatformNames()) {
            this.platformNames = new ArrayList<String>(other.getTransferZonePlatformNames());
        }
    }

    public long getTransferZoneId() {
        return this.transferZoneId;
    }

    public List<String> getTransferZonePlatformNames() {
        return this.platformNames;
    }

    public boolean addTransferZonePlatformName(String platformName) {
        if (platformName == null) {
            return false;
        }
        if (this.platformNames == null) {
            this.platformNames = new ArrayList<String>(1);
        } else if (this.platformNames.contains(platformName)) {
            return false;
        }
        this.platformNames.add(platformName);
        return true;
    }

    public boolean removeTransferZonePlatformName(String platformName) {
        return this.platformNames.remove(platformName);
    }

    public void setType(TransferZoneType type) {
        this.type = type;
    }

    public TransferZoneType getTransferZoneType() {
        return this.type;
    }

    public boolean hasTransferZoneGroup() {
        return this.transferZoneGroups != null && !this.transferZoneGroups.isEmpty();
    }

    public boolean isInTransferZoneGroup(TransferZoneGroup transferZoneGroup) {
        if (transferZoneGroup == null || !this.hasTransferZoneGroup()) {
            return false;
        }
        return this.transferZoneGroups.contains(transferZoneGroup);
    }

    public void addToTransferZoneGroup(TransferZoneGroup transferZoneGroup) {
        if (transferZoneGroup == null) {
            LOGGER.warning(String.format("transfer zone group null, unable to register on transfer zone %s", this.getXmlId()));
            return;
        }
        if (!this.hasTransferZoneGroup()) {
            this.transferZoneGroups = new HashSet<TransferZoneGroup>();
        }
        this.transferZoneGroups.add(transferZoneGroup);
    }

    public boolean removeFromTransferZoneGroup(TransferZoneGroup transferZoneGroup) {
        boolean success = false;
        if (this.isInTransferZoneGroup(transferZoneGroup)) {
            success = this.transferZoneGroups.remove(transferZoneGroup);
            if (this.transferZoneGroups.isEmpty()) {
                this.transferZoneGroups = null;
            }
            if (transferZoneGroup.hasTransferZone((TransferZone)this)) {
                transferZoneGroup.removeTransferZone((TransferZone)this);
            }
        }
        return success;
    }

    public void removeFromAllTransferZoneGroups() {
        if (this.hasTransferZoneGroup()) {
            Iterator<TransferZoneGroup> iterator = this.transferZoneGroups.iterator();
            while (iterator.hasNext()) {
                TransferZoneGroup group = iterator.next();
                iterator.remove();
                group.removeTransferZone((TransferZone)this);
            }
        }
    }

    public final Set<TransferZoneGroup> getTransferZoneGroups() {
        if (this.hasTransferZoneGroup()) {
            return Collections.unmodifiableSet(this.transferZoneGroups);
        }
        return null;
    }

    @Override
    public long recreateManagedIds(IdGroupingToken tokenId) {
        this.setTransferZoneId(TransferZoneImpl.generateTransferZoneId(tokenId));
        return super.recreateManagedIds(tokenId);
    }

    @Override
    public TransferZoneImpl shallowClone() {
        return new TransferZoneImpl(this, false);
    }

    @Override
    public TransferZoneImpl deepClone() {
        return new TransferZoneImpl(this, true);
    }
}

