/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.zoning;

import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import org.goplanit.utils.event.EventType;
import org.goplanit.utils.id.IdAble;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.id.ManagedIdEntitiesImpl;
import org.goplanit.utils.zoning.TransferZoneGroup;
import org.goplanit.utils.zoning.TransferZoneGroupFactory;
import org.goplanit.utils.zoning.TransferZoneGroups;
import org.goplanit.utils.zoning.modifier.event.ZoningModificationEvent;
import org.goplanit.zoning.ConnectoidsImpl;
import org.goplanit.zoning.TransferZoneGroupFactoryImpl;
import org.goplanit.zoning.TransferZoneGroupImpl;
import org.goplanit.zoning.modifier.event.ModifiedZoneIdsEvent;

public class TransferZoneGroupsImpl
extends ManagedIdEntitiesImpl<TransferZoneGroup>
implements TransferZoneGroups {
    private final TransferZoneGroupFactory transferZoneGroupFactory;
    private static final Logger LOGGER = Logger.getLogger(ConnectoidsImpl.class.getCanonicalName());

    protected void recreateTransferZoneGroupsZoneIdMapping() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            TransferZoneGroup group = (TransferZoneGroup)iterator.next();
            if (!(group instanceof TransferZoneGroupImpl)) {
                LOGGER.severe("recreation of transfer zone ids utilises unsupported implementation of TransferZoneGroup interface when attempting to update references");
            }
            ((TransferZoneGroupImpl)group).recreateTransferZoneIdMapping();
        }
    }

    public TransferZoneGroupsImpl(IdGroupingToken groupId) {
        super(IdAble::getId, TransferZoneGroup.TRANSFER_ZONE_GROUP_ID_CLASS);
        this.transferZoneGroupFactory = new TransferZoneGroupFactoryImpl(groupId, this);
    }

    public TransferZoneGroupsImpl(IdGroupingToken groupId, TransferZoneGroupFactory transferZoneGroupFactory) {
        super(IdAble::getId, TransferZoneGroup.TRANSFER_ZONE_GROUP_ID_CLASS);
        this.transferZoneGroupFactory = transferZoneGroupFactory;
    }

    public TransferZoneGroupsImpl(TransferZoneGroupsImpl other, boolean deepCopy, BiConsumer<TransferZoneGroup, TransferZoneGroup> mapper) {
        super((ManagedIdEntitiesImpl)other, deepCopy, mapper);
        this.transferZoneGroupFactory = new TransferZoneGroupFactoryImpl(other.transferZoneGroupFactory.getIdGroupingToken(), this);
    }

    public TransferZoneGroupFactory getFactory() {
        return this.transferZoneGroupFactory;
    }

    public EventType[] getKnownSupportedEventTypes() {
        return new EventType[]{ModifiedZoneIdsEvent.EVENT_TYPE};
    }

    public void onZoningModifierEvent(ZoningModificationEvent event) {
        if (event.getType().equals((Object)ModifiedZoneIdsEvent.EVENT_TYPE)) {
            this.recreateTransferZoneGroupsZoneIdMapping();
        }
    }

    public TransferZoneGroupsImpl shallowClone() {
        return new TransferZoneGroupsImpl(this, false, null);
    }

    public TransferZoneGroupsImpl deepClone() {
        return new TransferZoneGroupsImpl(this, true, null);
    }

    public TransferZoneGroupsImpl deepCloneWithMapping(BiConsumer<TransferZoneGroup, TransferZoneGroup> mapper) {
        return new TransferZoneGroupsImpl(this, true, mapper);
    }
}

