/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.zoning;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.goplanit.utils.id.ExternalIdAbleImpl;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.TransferZoneGroup;

public class TransferZoneGroupImpl
extends ExternalIdAbleImpl
implements TransferZoneGroup {
    protected Map<Long, TransferZone> transferZoneMap = new TreeMap<Long, TransferZone>();
    protected String name = null;

    protected void recreateTransferZoneIdMapping() {
        if (!this.transferZoneMap.isEmpty()) {
            TreeMap<Long, TransferZone> updatedMap = new TreeMap<Long, TransferZone>();
            this.transferZoneMap.forEach((oldId, transferzone) -> updatedMap.put(transferzone.getId(), (TransferZone)transferzone));
            this.transferZoneMap.clear();
            this.transferZoneMap = updatedMap;
        }
    }

    protected static long generateTransferZoneGroupId(IdGroupingToken tokenId) {
        return IdGenerator.generateId((IdGroupingToken)tokenId, TransferZoneGroup.class);
    }

    protected TransferZoneGroupImpl(IdGroupingToken tokenId) {
        super(TransferZoneGroupImpl.generateTransferZoneGroupId(tokenId));
    }

    public TransferZoneGroupImpl(TransferZoneGroupImpl other, boolean deepCopy) {
        super((ExternalIdAbleImpl)other);
        this.name = other.name;
        this.transferZoneMap = new HashMap<Long, TransferZone>(other.transferZoneMap);
    }

    public Iterator<TransferZone> iterator() {
        return this.transferZoneMap.values().iterator();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TransferZone addTransferZone(TransferZone transferZone) {
        TransferZone prevTransferZone = this.transferZoneMap.put(transferZone.getId(), transferZone);
        transferZone.addToTransferZoneGroup((TransferZoneGroup)this);
        return prevTransferZone;
    }

    public TransferZone removeTransferZone(TransferZone transferZone) {
        TransferZone removedZone = this.transferZoneMap.remove(transferZone.getId());
        if (transferZone.isInTransferZoneGroup((TransferZoneGroup)this)) {
            transferZone.removeFromTransferZoneGroup((TransferZoneGroup)this);
        }
        return removedZone;
    }

    public boolean hasTransferZone(TransferZone transferZone) {
        return this.transferZoneMap.containsKey(transferZone.getId());
    }

    public int size() {
        return this.transferZoneMap.size();
    }

    public Collection<TransferZone> getTransferZones() {
        return this.transferZoneMap.values();
    }

    public long recreateManagedIds(IdGroupingToken tokenId) {
        long newId = TransferZoneGroupImpl.generateTransferZoneGroupId(tokenId);
        this.setId(newId);
        return newId;
    }

    public TransferZoneGroupImpl shallowClone() {
        return new TransferZoneGroupImpl(this, false);
    }

    public TransferZoneGroupImpl deepClone() {
        return new TransferZoneGroupImpl(this, true);
    }
}

