/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.zoning;

import java.util.logging.Logger;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.zoning.ConnectoidImpl;

public class DirectedConnectoidImpl
extends ConnectoidImpl
implements DirectedConnectoid {
    private static final Logger LOGGER = Logger.getLogger(DirectedConnectoidImpl.class.getCanonicalName());
    protected long directedConnectoidId;
    protected LinkSegment accessEdgeSegment;
    protected boolean nodeAccessDownstream = true;

    protected static long generateDirectedConnectoidId(IdGroupingToken groupId) {
        return IdGenerator.generateId((IdGroupingToken)groupId, (Class)DirectedConnectoid.DIRECTED_CONNECTOID_ID_CLASS);
    }

    protected void setDirectedConnectoidId(long directedConnectoidId) {
        this.directedConnectoidId = directedConnectoidId;
    }

    protected void setAccessLinkSegment(LinkSegment accessEdgeSegment) {
        this.accessEdgeSegment = accessEdgeSegment;
    }

    protected DirectedConnectoidImpl(IdGroupingToken idToken, boolean downstreamAccessNode, LinkSegment accessLinkSegment, Zone accessZone, double length) {
        super(idToken, accessZone, length);
        this.setDirectedConnectoidId(DirectedConnectoidImpl.generateDirectedConnectoidId(idToken));
        this.setAccessLinkSegment(accessLinkSegment);
        this.setNodeAccessDownstream(downstreamAccessNode);
    }

    protected DirectedConnectoidImpl(IdGroupingToken idToken, boolean downstreamAccessNode, LinkSegment accessLinkSegment) {
        super(idToken);
        this.setDirectedConnectoidId(DirectedConnectoidImpl.generateDirectedConnectoidId(idToken));
        this.setAccessLinkSegment(accessLinkSegment);
        this.setNodeAccessDownstream(downstreamAccessNode);
    }

    protected DirectedConnectoidImpl(DirectedConnectoidImpl other, boolean deepCopy) {
        super(other, deepCopy);
        this.setDirectedConnectoidId(other.getDirectedConnectoidId());
        this.setAccessLinkSegment(other.getAccessLinkSegment());
        this.setNodeAccessDownstream(other.isNodeAccessDownstream());
    }

    public long getDirectedConnectoidId() {
        return this.directedConnectoidId;
    }

    public LinkSegment getAccessLinkSegment() {
        return this.accessEdgeSegment;
    }

    public void replaceAccessLinkSegment(LinkSegment accessEdgeSegment) {
        this.setAccessLinkSegment(accessEdgeSegment);
    }

    public boolean isNodeAccessDownstream() {
        return this.nodeAccessDownstream;
    }

    public void setNodeAccessDownstream(boolean nodeAccessDownstream) {
        this.nodeAccessDownstream = nodeAccessDownstream;
    }

    public DirectedVertex getAccessVertex() {
        return this.isNodeAccessDownstream() ? this.getAccessLinkSegment().getDownstreamVertex() : this.getAccessLinkSegment().getUpstreamVertex();
    }

    @Override
    public long recreateManagedIds(IdGroupingToken tokenId) {
        this.setDirectedConnectoidId(DirectedConnectoidImpl.generateDirectedConnectoidId(tokenId));
        return super.recreateManagedIds(tokenId);
    }

    @Override
    public DirectedConnectoidImpl shallowClone() {
        return new DirectedConnectoidImpl(this, false);
    }

    @Override
    public DirectedConnectoidImpl deepClone() {
        return new DirectedConnectoidImpl(this, true);
    }
}

