/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.zoning;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import org.goplanit.utils.event.EventType;
import org.goplanit.utils.id.IdAble;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.id.ManagedIdEntitiesImpl;
import org.goplanit.utils.zoning.Connectoid;
import org.goplanit.utils.zoning.Connectoids;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.utils.zoning.modifier.event.ZoningModificationEvent;
import org.goplanit.zoning.ConnectoidImpl;
import org.goplanit.zoning.modifier.event.ModifiedZoneIdsEvent;

public abstract class ConnectoidsImpl<T extends Connectoid>
extends ManagedIdEntitiesImpl<T>
implements Connectoids<T> {
    private static final Logger LOGGER = Logger.getLogger(ConnectoidsImpl.class.getCanonicalName());

    protected void updateConnectoidAccessZoneIdReferences() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Connectoid connectoid = (Connectoid)iterator.next();
            if (!(connectoid instanceof ConnectoidImpl)) {
                LOGGER.severe("recreation of transfer zone ids utilises unsupported implementation of connectoids interface when attempting to update access zone references");
            }
            ((ConnectoidImpl)connectoid).recreateAccessZoneIdMapping();
        }
    }

    public ConnectoidsImpl(IdGroupingToken groupId) {
        super(IdAble::getId, Connectoid.CONNECTOID_ID_CLASS);
    }

    public ConnectoidsImpl(ConnectoidsImpl<T> other, boolean deepCopy, BiConsumer<T, T> mapper) {
        super(other, deepCopy, mapper);
    }

    public EventType[] getKnownSupportedEventTypes() {
        return new EventType[]{ModifiedZoneIdsEvent.EVENT_TYPE};
    }

    public void onZoningModifierEvent(ZoningModificationEvent event) {
        if (event.getType().equals((Object)ModifiedZoneIdsEvent.EVENT_TYPE)) {
            this.updateConnectoidAccessZoneIdReferences();
        }
    }

    public Map<Zone, Set<T>> createIndexByAccessZone() {
        HashMap<Zone, Set<T>> indexByAccessZone = new HashMap<Zone, Set<T>>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Connectoid connectoid = (Connectoid)iterator.next();
            for (Zone validAccessZone : connectoid) {
                indexByAccessZone.putIfAbsent(validAccessZone, new HashSet());
                indexByAccessZone.get(validAccessZone).add(connectoid);
            }
        }
        return indexByAccessZone;
    }

    public abstract ConnectoidsImpl<T> shallowClone();

    public abstract ConnectoidsImpl<T> deepClone();

    public abstract ConnectoidsImpl deepCloneWithMapping(BiConsumer<T, T> var1);
}

