/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.zoning;

import org.goplanit.utils.id.IdAbleImpl;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.zoning.Centroid;
import org.goplanit.utils.zoning.Zone;
import org.locationtech.jts.geom.Point;

public class CentroidImpl
extends IdAbleImpl
implements Centroid {
    private static final long serialVersionUID = 1122451267627721268L;
    private Zone parentZone;
    private String name;
    private Point position;

    protected static long generateId(IdGroupingToken tokenId) {
        return IdGenerator.generateId((IdGroupingToken)tokenId, (Class)CENTROID_ID_CLASS);
    }

    protected CentroidImpl(IdGroupingToken groupId) {
        this(groupId, null);
    }

    protected CentroidImpl(IdGroupingToken groupId, Zone parentZone) {
        super(CentroidImpl.generateId(groupId));
        this.setParentZone(parentZone);
    }

    protected CentroidImpl(CentroidImpl other, boolean deepCopy) {
        super((IdAbleImpl)other);
        this.setParentZone(other.getParentZone());
        this.setName(other.getName());
    }

    public CentroidImpl shallowClone() {
        return new CentroidImpl(this, false);
    }

    public CentroidImpl deepClone() {
        return new CentroidImpl(this, true);
    }

    public long recreateManagedIds(IdGroupingToken tokenId) {
        long newId = CentroidImpl.generateId(tokenId);
        this.setId(newId);
        return newId;
    }

    public Zone getParentZone() {
        return this.parentZone;
    }

    public void setParentZone(Zone parentZone) {
        this.parentZone = parentZone;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Point getPosition() {
        return this.position;
    }

    public void setPosition(Point position) {
        this.position = position;
    }
}

