/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.userclass;

import org.goplanit.userclass.TravellerType;
import org.goplanit.utils.id.ExternalIdAbleImpl;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.id.ManagedId;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.utils.mode.Mode;

public class UserClass
extends ExternalIdAbleImpl
implements ManagedId {
    private final String name;
    private final Mode mode;
    private TravellerType travellerType;
    public static final Class<UserClass> USERCLASS_ID_CLASS = UserClass.class;
    public static final String DEFAULT_NAME = "Default";
    public static final String DEFAULT_XML_ID = "1";

    protected static long generateId(IdGroupingToken tokenId) {
        return IdGenerator.generateId((IdGroupingToken)tokenId, USERCLASS_ID_CLASS);
    }

    public UserClass(IdGroupingToken groupId, String name, Mode mode, TravellerType travelerType) {
        super(IdGenerator.generateId((IdGroupingToken)groupId, UserClass.class));
        this.name = name;
        this.travellerType = travelerType;
        this.mode = mode;
    }

    public UserClass(UserClass other) {
        super((ExternalIdAbleImpl)other);
        this.name = other.name;
        this.travellerType = other.travellerType;
        this.mode = other.mode;
    }

    public long recreateManagedIds(IdGroupingToken tokenId) {
        long newId = UserClass.generateId(tokenId);
        this.setId(newId);
        return newId;
    }

    public Class<? extends UserClass> getIdClass() {
        return USERCLASS_ID_CLASS;
    }

    public TravellerType getTravelerType() {
        return this.travellerType;
    }

    public void setTravellerType(TravellerType travellerType) {
        this.travellerType = travellerType;
    }

    public boolean hasName() {
        return !StringUtils.isNullOrBlank((String)this.name);
    }

    public String getName() {
        return this.name;
    }

    public Mode getMode() {
        return this.mode;
    }

    public UserClass shallowClone() {
        return new UserClass(this);
    }

    public UserClass deepClone() {
        return this.shallowClone();
    }

    public String toString() {
        return String.format("[id: %d, XMLid: %s, name: %s, mode %s, travellertype %s]", this.getId(), this.getXmlId(), this.getName(), this.getMode().toString(), this.travellerType.toString());
    }
}

