/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.time;

import java.util.logging.Logger;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.id.ExternalIdAbleImpl;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.time.TimePeriod;

public class TimePeriodImpl
extends ExternalIdAbleImpl
implements TimePeriod {
    private static final Logger LOGGER = Logger.getLogger(TimePeriodImpl.class.getCanonicalName());
    private final long startTimeSeconds;
    private final long durationSeconds;
    private final String description;

    protected static long generateId(IdGroupingToken tokenId) {
        return IdGenerator.generateId((IdGroupingToken)tokenId, (Class)TimePeriod.TIMEPERIOD_ID_CLASS);
    }

    public TimePeriodImpl(IdGroupingToken groupId, long startTimeSeconds, long durationSeconds) {
        super(IdGenerator.generateId((IdGroupingToken)groupId, TimePeriod.class));
        PlanItRunTimeException.throwIf(((double)durationSeconds > 86400.0 ? 1 : 0) != 0, (String)"Duration more than 24 hours", (Object[])new Object[0]);
        PlanItRunTimeException.throwIf(((double)startTimeSeconds > 86400.0 ? 1 : 0) != 0, (String)"Start time later than 24 hours", (Object[])new Object[0]);
        this.startTimeSeconds = startTimeSeconds;
        this.durationSeconds = durationSeconds;
        this.description = null;
    }

    public TimePeriodImpl(IdGroupingToken groupId, String description, long startTimeSeconds, long durationSeconds) {
        super(IdGenerator.generateId((IdGroupingToken)groupId, TimePeriod.class));
        PlanItRunTimeException.throwIf(((double)durationSeconds > 86400.0 ? 1 : 0) != 0, (String)"Duration more than 24 hours", (Object[])new Object[0]);
        PlanItRunTimeException.throwIf(((double)startTimeSeconds > 86400.0 ? 1 : 0) != 0, (String)"Start time later than 24 hours", (Object[])new Object[0]);
        this.startTimeSeconds = startTimeSeconds;
        this.durationSeconds = durationSeconds;
        this.description = description;
    }

    public TimePeriodImpl(TimePeriodImpl timePeriodImpl, boolean deepCopy) {
        super((ExternalIdAbleImpl)timePeriodImpl);
        this.startTimeSeconds = timePeriodImpl.startTimeSeconds;
        this.durationSeconds = timePeriodImpl.durationSeconds;
        this.description = timePeriodImpl.description;
    }

    public long getStartTimeSeconds() {
        return this.startTimeSeconds;
    }

    public long getDurationSeconds() {
        return this.durationSeconds;
    }

    public String getDescription() {
        return this.description;
    }

    public long recreateManagedIds(IdGroupingToken tokenId) {
        long newId = TimePeriodImpl.generateId(tokenId);
        this.setId(newId);
        return newId;
    }

    public TimePeriodImpl shallowClone() {
        return new TimePeriodImpl(this, false);
    }

    public TimePeriodImpl deepClone() {
        return new TimePeriodImpl(this, true);
    }

    public String toString() {
        long endTime = this.startTimeSeconds + this.durationSeconds;
        return String.format("start time: %02d:%02d ", this.startTimeSeconds / 3600L, this.startTimeSeconds % 3600L / 60L) + String.format("- end time: %02d:%02d", endTime / 3600L, endTime % 3600L / 60L);
    }
}

