/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.test;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public class PlanItTestHelper {
    private static final Logger LOGGER = Logger.getLogger(PlanItTestHelper.class.getCanonicalName());

    public static boolean compareFilesExact(String file1, String file2, boolean printFilesOnFalse) throws IOException {
        String charSetName = "utf-8";
        Path f1 = Path.of(file1, new String[0]).toAbsolutePath();
        if (Files.notExists(f1, new LinkOption[0])) {
            LOGGER.warning(String.format("File %s does not exist, printing available xml and csv files in dir", f1));
            FileUtils.listFiles((File)f1.getParent().toFile(), (String[])new String[]{"csv", "xml"}, (boolean)false).forEach(f -> LOGGER.warning(f.toString()));
            return false;
        }
        Path f2 = Path.of(file2, new String[0]).toAbsolutePath();
        if (Files.notExists(f2, new LinkOption[0])) {
            LOGGER.warning(String.format("File %s does not exist, printing available xml and csv files in dir", f2));
            FileUtils.listFiles((File)f2.getParent().toFile(), (String[])new String[]{"csv", "xml"}, (boolean)false).forEach(f -> LOGGER.warning(f.toString()));
            return false;
        }
        boolean contentEquals = FileUtils.contentEqualsIgnoreEOL((File)f1.toFile(), (File)f2.toFile(), (String)"utf-8");
        if (!contentEquals && printFilesOnFalse) {
            LOGGER.warning("FILE NOT THE SAME: Printing contents for comparison");
            LOGGER.warning("File 1:");
            LOGGER.warning(FileUtils.readFileToString((File)f1.toFile(), (String)"utf-8"));
            LOGGER.warning("File 2:");
            LOGGER.warning(FileUtils.readFileToString((File)f2.toFile(), (String)"utf-8"));
        }
        return contentEquals;
    }
}

