/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.supply.fundamentaldiagram;

import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.supply.fundamentaldiagram.FundamentalDiagram;
import org.goplanit.supply.fundamentaldiagram.FundamentalDiagramComponent;
import org.goplanit.supply.fundamentaldiagram.NewellFundamentalDiagram;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.math.Precision;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentType;

public class NewellFundamentalDiagramComponent
extends FundamentalDiagramComponent {
    private static final long serialVersionUID = -3166623064510413929L;
    private static final Logger LOGGER = Logger.getLogger(NewellFundamentalDiagramComponent.class.getCanonicalName());

    @Override
    protected void initialiseDefaultFundamentalDiagramsForLayer(MacroscopicNetworkLayer parentNetworkLayer) {
        Mode mode = parentNetworkLayer.getFirstSupportedMode();
        for (MacroscopicLinkSegmentType linkSegmentType : parentNetworkLayer.getLinkSegmentTypes()) {
            if (linkSegmentType.isModeAllowed(mode)) {
                NewellFundamentalDiagram newellFd = null;
                double modeSpeed = linkSegmentType.getMaximumSpeedKmH(mode);
                newellFd = !linkSegmentType.isExplicitMaximumDensityPerLaneSet() && !linkSegmentType.isExplicitCapacityPerLaneSet() ? new NewellFundamentalDiagram(modeSpeed) : (!linkSegmentType.isExplicitMaximumDensityPerLaneSet() ? new NewellFundamentalDiagram(modeSpeed, linkSegmentType.getExplicitCapacityPerLane(), linkSegmentType.getExplicitMaximumDensityPerLaneOrDefault()) : new NewellFundamentalDiagram(modeSpeed, linkSegmentType.getExplicitMaximumDensityPerLane()));
                this.register(linkSegmentType, newellFd);
                continue;
            }
            LOGGER.info(String.format("IGNORE: Macroscopic link segment type %s has no modes used by the assignment", linkSegmentType.getXmlId()));
        }
        for (MacroscopicLinkSegment linkSegment : parentNetworkLayer.getLinkSegments()) {
            if (!Precision.smaller((double)linkSegment.getPhysicalSpeedLimitKmH(), (double)linkSegment.getLinkSegmentType().getMaximumSpeedKmH(mode))) continue;
            LOGGER.warning(String.format("Physical speed limit (%.2f) on link segment %s is more restrictive than the speed limit (%.2f) of the applied link segment type %s", linkSegment.getPhysicalSpeedLimitKmH(), linkSegment.getXmlId(), linkSegment.getLinkSegmentType().getMaximumSpeedKmH(mode), linkSegment.getLinkSegmentType().getXmlId()));
            double modeSpeedLimit = linkSegment.getModelledSpeedLimitKmH(mode);
            LOGGER.info(String.format("Overwriting fundamental diagram used on link segment %s, restricting free flow speed to %.2f", linkSegment.getXmlId(), modeSpeedLimit));
            NewellFundamentalDiagram oldFd = (NewellFundamentalDiagram)this.get(linkSegment);
            NewellFundamentalDiagram newFd = oldFd.shallowClone();
            newFd.setMaximumSpeedKmHour(modeSpeedLimit);
            this.register(linkSegment, newFd);
        }
    }

    public NewellFundamentalDiagramComponent(IdGroupingToken groupId) {
        super(groupId);
    }

    public NewellFundamentalDiagramComponent(NewellFundamentalDiagramComponent other, boolean deepCopy) {
        super(other, deepCopy);
    }

    @Override
    public NewellFundamentalDiagramComponent shallowClone() {
        return new NewellFundamentalDiagramComponent(this, false);
    }

    @Override
    public NewellFundamentalDiagramComponent deepClone() {
        return new NewellFundamentalDiagramComponent(this, true);
    }

    public FundamentalDiagram register(MacroscopicLinkSegment linkSegment, NewellFundamentalDiagram fundamentalDiagram) {
        return super.register(linkSegment, (FundamentalDiagram)fundamentalDiagram);
    }

    public FundamentalDiagram register(MacroscopicLinkSegmentType linkSegmentType, NewellFundamentalDiagram fundamentalDiagram) {
        return super.register(linkSegmentType, (FundamentalDiagram)fundamentalDiagram);
    }

    @Override
    public Map<String, String> collectSettingsAsKeyValueMap() {
        return null;
    }
}

