/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.supply.fundamentaldiagram;

import org.goplanit.supply.fundamentaldiagram.FundamentalDiagramImpl;
import org.goplanit.supply.fundamentaldiagram.LinearFundamentalDiagramBranch;

public class NewellFundamentalDiagram
extends FundamentalDiagramImpl {
    protected double computeBackwardWaveSpeedForCapacity(double capacityPcuHour) {
        double newCriticalDensity = this.getFreeFlowBranch().getDensityPcuKm(capacityPcuHour);
        double jamDensity = this.getCongestedBranch().getDensityPcuKm(0.0);
        return capacityPcuHour / (newCriticalDensity - jamDensity);
    }

    public NewellFundamentalDiagram(double freeSpeedKmHour) {
        this(freeSpeedKmHour, 180.0);
    }

    public NewellFundamentalDiagram(double freeSpeedKmHour, double jamDensityPcuKm) {
        super(new LinearFundamentalDiagramBranch(freeSpeedKmHour, 0.0), new LinearFundamentalDiagramBranch(-12.5, jamDensityPcuKm));
    }

    public NewellFundamentalDiagram(double freeSpeedKmHour, double capacityPcuHour, double jamDensityPcuKm) {
        this(freeSpeedKmHour, jamDensityPcuKm);
        this.setCapacityPcuHour(capacityPcuHour);
    }

    public NewellFundamentalDiagram(LinearFundamentalDiagramBranch freeFlowBranch, LinearFundamentalDiagramBranch congestedBranch) {
        super(freeFlowBranch, congestedBranch);
    }

    public NewellFundamentalDiagram(NewellFundamentalDiagram other, boolean deepCopy) {
        super(other, deepCopy);
    }

    @Override
    public LinearFundamentalDiagramBranch getFreeFlowBranch() {
        return (LinearFundamentalDiagramBranch)super.getFreeFlowBranch();
    }

    @Override
    public LinearFundamentalDiagramBranch getCongestedBranch() {
        return (LinearFundamentalDiagramBranch)super.getCongestedBranch();
    }

    @Override
    public double getCapacityFlowPcuHour() {
        double maxSpeed = this.getMaximumSpeedKmHour();
        double backwardWaveSpeed = this.getCongestedBranch().getCharateristicWaveSpeedKmHour();
        double kCrit = -(this.getMaximumDensityPcuKm() * backwardWaveSpeed / (maxSpeed - backwardWaveSpeed));
        return kCrit * maxSpeed;
    }

    @Override
    public NewellFundamentalDiagram shallowClone() {
        return new NewellFundamentalDiagram(this, false);
    }

    @Override
    public NewellFundamentalDiagram deepClone() {
        return new NewellFundamentalDiagram(this, true);
    }

    @Override
    public void setCapacityPcuHour(double capacityPcuHour) {
        double backwardWaveSpeedForCapacity = this.computeBackwardWaveSpeedForCapacity(capacityPcuHour);
        this.getCongestedBranch().setCharacteristicWaveSpeedKmHour(backwardWaveSpeedForCapacity);
    }

    @Override
    public void setMaximumDensityPcuKmHour(double maxDensityPcuKm) {
        this.getCongestedBranch().setDensityAtZeroFlow(maxDensityPcuKm);
    }

    @Override
    public void setMaximumSpeedKmHour(double maxSpeedKmHour) {
        this.getFreeFlowBranch().setCharacteristicWaveSpeedKmHour(maxSpeedKmHour);
    }
}

