/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.service.routed.modifier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.service.routed.RoutedServicesLayerImpl;
import org.goplanit.service.routed.modifier.event.ModifiedRoutedServicesIdsEvent;
import org.goplanit.service.routed.modifier.event.ModifiedRoutedTripIdsEvent;
import org.goplanit.utils.containers.IntegerListUtils;
import org.goplanit.utils.containers.ListUtils;
import org.goplanit.utils.event.Event;
import org.goplanit.utils.event.EventListener;
import org.goplanit.utils.event.EventProducerImpl;
import org.goplanit.utils.event.EventType;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.id.ManagedId;
import org.goplanit.utils.misc.CharacterUtils;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.ServiceNetworkLayer;
import org.goplanit.utils.service.routed.RelativeLegTimingUtils;
import org.goplanit.utils.service.routed.RoutedModeServices;
import org.goplanit.utils.service.routed.RoutedService;
import org.goplanit.utils.service.routed.RoutedServicesLayer;
import org.goplanit.utils.service.routed.RoutedTrip;
import org.goplanit.utils.service.routed.RoutedTripDeparture;
import org.goplanit.utils.service.routed.RoutedTripDepartures;
import org.goplanit.utils.service.routed.RoutedTripFactory;
import org.goplanit.utils.service.routed.RoutedTripFrequency;
import org.goplanit.utils.service.routed.RoutedTripFrequencyFactory;
import org.goplanit.utils.service.routed.RoutedTripFrequencyUtils;
import org.goplanit.utils.service.routed.RoutedTripSchedule;
import org.goplanit.utils.service.routed.RoutedTripScheduleFactory;
import org.goplanit.utils.service.routed.RoutedTripsFrequency;
import org.goplanit.utils.service.routed.RoutedTripsSchedule;
import org.goplanit.utils.service.routed.modifier.RoutedServicesLayerModifier;
import org.goplanit.utils.service.routed.modifier.RoutedServicesModificationEvent;
import org.goplanit.utils.service.routed.modifier.RoutedServicesModifierEventType;
import org.goplanit.utils.service.routed.modifier.RoutedServicesModifierListener;
import org.goplanit.zoning.modifier.event.ModifiedTripScheduleDepartureIdsEvent;

public class RoutedServicesLayerModifierImpl
extends EventProducerImpl
implements RoutedServicesLayerModifier {
    private static final Logger LOGGER = Logger.getLogger(RoutedServicesLayerModifierImpl.class.getCanonicalName());
    protected final RoutedServicesLayerImpl routedServicesLayer;

    private <T extends RoutedTrip> List<T> recursiveTruncateXTripChainToServiceNetwork(int indexOffset, List<Integer> toBeRemovedSegments, T freqOrSched, RoutedTripFactory<T> factory) {
        int nextRecursionIndexOffset;
        if (indexOffset >= toBeRemovedSegments.size()) {
            return null;
        }
        boolean isTripSchedule = freqOrSched instanceof RoutedTripSchedule;
        if (!isTripSchedule && !(freqOrSched instanceof RoutedTripFrequency)) {
            throw new PlanItRunTimeException("Only routed trip schedule or routed trip frequencies are supported in recurive truncation to service network");
        }
        int numSegments = isTripSchedule ? ((RoutedTripSchedule)freqOrSched).getRelativeLegTimingsSize() : ((RoutedTripFrequency)freqOrSched).getNumberOfLegSegments();
        boolean isFirstChainTruncation = indexOffset == -1;
        indexOffset = Math.max(0, indexOffset);
        boolean initialChainWithoutRemovalBeforeChain = isFirstChainTruncation && toBeRemovedSegments.get(0) > 0;
        List consecutiveLegsToRemoveBeforeChain = initialChainWithoutRemovalBeforeChain ? List.of() : IntegerListUtils.getLongestConsecutiveSubList((int)indexOffset, toBeRemovedSegments);
        List allIndicesBeforeFirstChainLeg = initialChainWithoutRemovalBeforeChain ? List.of() : IntegerListUtils.rangeOf((int)0, (int)((Integer)ListUtils.getLastValue((List)consecutiveLegsToRemoveBeforeChain) + 1));
        int n = nextRecursionIndexOffset = initialChainWithoutRemovalBeforeChain ? 0 : Math.min(indexOffset + consecutiveLegsToRemoveBeforeChain.size(), toBeRemovedSegments.size());
        if (!initialChainWithoutRemovalBeforeChain && (Integer)ListUtils.getLastValue((List)consecutiveLegsToRemoveBeforeChain) == numSegments - 1) {
            return null;
        }
        RoutedTrip truncatedRoutedTripX = isTripSchedule ? (RoutedTrip)((RoutedTripScheduleFactory)factory).createUniqueDeepCopyOf((ManagedId)((RoutedTripSchedule)freqOrSched)) : (RoutedTrip)((RoutedTripFrequencyFactory)factory).createUniqueDeepCopyOf((ManagedId)((RoutedTripFrequency)freqOrSched));
        boolean lastChainWithoutRemovalAfter = nextRecursionIndexOffset >= toBeRemovedSegments.size();
        ArrayList truncatedSegmentIndicesToRemove = new ArrayList(allIndicesBeforeFirstChainLeg);
        if (!lastChainWithoutRemovalAfter) {
            int firstLegIndexValueToRemoveAfterChain = toBeRemovedSegments.get(nextRecursionIndexOffset);
            List allIndicesAfterLastChainLeg = IntegerListUtils.rangeOf((int)firstLegIndexValueToRemoveAfterChain, (int)numSegments);
            truncatedSegmentIndicesToRemove.addAll(allIndicesAfterLastChainLeg);
        }
        if (isTripSchedule) {
            ((RoutedTripSchedule)truncatedRoutedTripX).removeLegTimingsIn(truncatedSegmentIndicesToRemove);
        } else {
            ((RoutedTripFrequency)truncatedRoutedTripX).removeLegSegmentsIn(truncatedSegmentIndicesToRemove);
        }
        List<T> recursiveResult = this.recursiveTruncateXTripChainToServiceNetwork(nextRecursionIndexOffset, toBeRemovedSegments, freqOrSched, factory);
        if (recursiveResult == null) {
            recursiveResult = new ArrayList<T>(1);
        }
        recursiveResult.add(truncatedRoutedTripX);
        return recursiveResult;
    }

    private List<RoutedTripFrequency> truncateFrequencyTripChainToServiceNetwork(List<Integer> toBeRemovedLegSegments, RoutedTripFrequency routedTripFrequency, RoutedTripFrequencyFactory factory) {
        return this.recursiveTruncateXTripChainToServiceNetwork(-1, toBeRemovedLegSegments, (RoutedTrip)routedTripFrequency, (RoutedTripFactory)factory);
    }

    private List<RoutedTripSchedule> truncateScheduledTripChainToServiceNetwork(List<Integer> toBeRemovedRelTimingSegments, RoutedTripSchedule routedTripSchedule, RoutedTripScheduleFactory factory) {
        return this.recursiveTruncateXTripChainToServiceNetwork(-1, toBeRemovedRelTimingSegments, (RoutedTrip)routedTripSchedule, (RoutedTripFactory)factory);
    }

    private List<RoutedTripFrequency> truncateFrequencyTripToServiceNetwork(RoutedTripFrequency routedTripFrequency, RoutedTripFrequencyFactory factory) {
        List toBeRemovedLegSegments = RoutedTripFrequencyUtils.findServiceLegSegmentsNotMappedToServiceNetwork((RoutedTripFrequency)routedTripFrequency, (ServiceNetworkLayer)this.routedServicesLayer.getParentLayer());
        if (toBeRemovedLegSegments.isEmpty()) {
            return null;
        }
        if (toBeRemovedLegSegments.size() == routedTripFrequency.getNumberOfLegSegments()) {
            routedTripFrequency.clear();
            return null;
        }
        List<RoutedTripFrequency> truncatedRoutedTripFrequencies = this.truncateFrequencyTripChainToServiceNetwork(toBeRemovedLegSegments, routedTripFrequency, factory);
        if (truncatedRoutedTripFrequencies == null || truncatedRoutedTripFrequencies.isEmpty()) {
            throw new PlanItRunTimeException("Invalid truncation of routed trip frequency, expected at least one alternative to be created");
        }
        routedTripFrequency.clear();
        return truncatedRoutedTripFrequencies;
    }

    private List<RoutedTripSchedule> truncateScheduledTripToServiceNetwork(RoutedTripSchedule routedTripSchedule, RoutedTripScheduleFactory factory) {
        List toBeRemovedRelativeTimingLegSegments = RelativeLegTimingUtils.findLegTimingsNotMappedToServiceNetwork((RoutedTripSchedule)routedTripSchedule, (RoutedServicesLayer)this.routedServicesLayer);
        if (toBeRemovedRelativeTimingLegSegments.isEmpty()) {
            return null;
        }
        if (toBeRemovedRelativeTimingLegSegments.size() == routedTripSchedule.getRelativeLegTimingsSize()) {
            routedTripSchedule.clear();
            return null;
        }
        List<RoutedTripSchedule> truncatedRoutedTripSchedules = this.truncateScheduledTripChainToServiceNetwork(toBeRemovedRelativeTimingLegSegments, routedTripSchedule, factory);
        if (truncatedRoutedTripSchedules == null || truncatedRoutedTripSchedules.isEmpty()) {
            throw new PlanItRunTimeException("Invalid truncation of routed trip schedule, expected at least one alternative schedule to be created");
        }
        routedTripSchedule.clear();
        return truncatedRoutedTripSchedules;
    }

    private Map<RoutedTripFrequency, Collection<RoutedTripFrequency>> truncateRoutedServiceFrequenciesToServiceNetwork(RoutedService routedService) {
        RoutedTripsFrequency frequencyTrips = routedService.getTripInfo().getFrequencyBasedTrips();
        Iterator frequencyIterator = frequencyTrips.iterator();
        HashMap<RoutedTripFrequency, Collection<RoutedTripFrequency>> result = new HashMap<RoutedTripFrequency, Collection<RoutedTripFrequency>>();
        while (frequencyIterator.hasNext()) {
            RoutedTripFrequency currEntry = (RoutedTripFrequency)frequencyIterator.next();
            List<RoutedTripFrequency> currReplacementFrequencyTrips = this.truncateFrequencyTripToServiceNetwork(currEntry, frequencyTrips.getFactory());
            result.put(currEntry, currReplacementFrequencyTrips);
            if (currEntry.hasPositiveFrequency()) continue;
            frequencyIterator.remove();
        }
        return result;
    }

    private Map<RoutedTripSchedule, Collection<RoutedTripSchedule>> createTruncatedRoutedServiceSchedulesToServiceNetwork(RoutedService routedService) {
        RoutedTripsSchedule scheduledTrips = routedService.getTripInfo().getScheduleBasedTrips();
        Iterator scheduleIterator = scheduledTrips.iterator();
        HashMap<RoutedTripSchedule, Collection<RoutedTripSchedule>> result = new HashMap<RoutedTripSchedule, Collection<RoutedTripSchedule>>();
        while (scheduleIterator.hasNext()) {
            RoutedTripSchedule currEntry = (RoutedTripSchedule)scheduleIterator.next();
            List<RoutedTripSchedule> currReplacementScheduledTrips = this.truncateScheduledTripToServiceNetwork(currEntry, scheduledTrips.getFactory());
            result.put(currEntry, currReplacementScheduledTrips);
            if (!currEntry.getDepartures().isEmpty() && currEntry.hasRelativeLegTimings()) continue;
            scheduleIterator.remove();
        }
        return result;
    }

    private void truncateFrequencyServicesToServiceNetworkByMode(RoutedModeServices servicesByMode) {
        int numKeptFrequencyTrips = 0;
        int numRemovedFrequencyTrips = 0;
        int numCreatedTruncatedFrequencyTrips = 0;
        for (RoutedService routedService : servicesByMode) {
            Map<RoutedTripFrequency, Collection<RoutedTripFrequency>> truncatedFrequencyBasedByOriginal = this.truncateRoutedServiceFrequenciesToServiceNetwork(routedService);
            for (Map.Entry<RoutedTripFrequency, Collection<RoutedTripFrequency>> entry : truncatedFrequencyBasedByOriginal.entrySet()) {
                if (entry.getValue() == null || entry.getValue().isEmpty()) {
                    boolean frequencyKept = entry.getKey().hasLegSegments() && entry.getKey().hasPositiveFrequency();
                    numKeptFrequencyTrips = frequencyKept ? numKeptFrequencyTrips + 1 : numKeptFrequencyTrips;
                    numRemovedFrequencyTrips = !frequencyKept ? numRemovedFrequencyTrips + 1 : numRemovedFrequencyTrips;
                    continue;
                }
                ++numRemovedFrequencyTrips;
                Collection<RoutedTripFrequency> currCreatedTruncatedFrequencies = entry.getValue();
                numCreatedTruncatedFrequencyTrips += currCreatedTruncatedFrequencies.size();
                currCreatedTruncatedFrequencies.stream().forEach(singleRtf -> routedService.getTripInfo().getFrequencyBasedTrips().register(singleRtf));
            }
        }
        LOGGER.info(String.format("%s[%s] # kept frequency based trips as is : %d", LoggingUtils.routedServiceLayerPrefix((long)this.routedServicesLayer.getId()), servicesByMode.getMode(), numKeptFrequencyTrips));
        LOGGER.info(String.format("%s[%s] # removed/replaced frequency based trips : %d", LoggingUtils.routedServiceLayerPrefix((long)this.routedServicesLayer.getId()), servicesByMode.getMode(), numRemovedFrequencyTrips));
        LOGGER.info(String.format("%s[%s] # newly created partials of frequency based trips : %d", LoggingUtils.routedServiceLayerPrefix((long)this.routedServicesLayer.getId()), servicesByMode.getMode(), numCreatedTruncatedFrequencyTrips));
    }

    private void truncateScheduledServicesToServiceNetworkByMode(RoutedModeServices servicesByMode) {
        int numKeptScheduledTrips = 0;
        int numRemovedScheduledTrips = 0;
        int numCreatedTruncatedScheduledTrips = 0;
        for (RoutedService routedService : servicesByMode) {
            Map<RoutedTripSchedule, Collection<RoutedTripSchedule>> truncatedSchedulesByOriginal = this.createTruncatedRoutedServiceSchedulesToServiceNetwork(routedService);
            for (Map.Entry<RoutedTripSchedule, Collection<RoutedTripSchedule>> entry : truncatedSchedulesByOriginal.entrySet()) {
                if (entry.getValue() == null || entry.getValue().isEmpty()) {
                    boolean scheduleKept = !entry.getKey().getDepartures().isEmpty();
                    numKeptScheduledTrips = scheduleKept ? numKeptScheduledTrips + 1 : numKeptScheduledTrips;
                    numRemovedScheduledTrips = !scheduleKept ? numRemovedScheduledTrips + 1 : numRemovedScheduledTrips;
                    continue;
                }
                ++numRemovedScheduledTrips;
                Collection<RoutedTripSchedule> currCreatedTruncatedSchedules = entry.getValue();
                numCreatedTruncatedScheduledTrips += currCreatedTruncatedSchedules.size();
                currCreatedTruncatedSchedules.stream().forEach(singleRts -> routedService.getTripInfo().getScheduleBasedTrips().register(singleRts));
            }
        }
        LOGGER.info(String.format("%s[%s] # kept scheduled trips as is : %d", LoggingUtils.routedServiceLayerPrefix((long)this.routedServicesLayer.getId()), servicesByMode.getMode(), numKeptScheduledTrips));
        LOGGER.info(String.format("%s[%s] # removed/replaced scheduled trips : %d", LoggingUtils.routedServiceLayerPrefix((long)this.routedServicesLayer.getId()), servicesByMode.getMode(), numRemovedScheduledTrips));
        LOGGER.info(String.format("%s[%s] # newly created partials of scheduled trips : %d", LoggingUtils.routedServiceLayerPrefix((long)this.routedServicesLayer.getId()), servicesByMode.getMode(), numCreatedTruncatedScheduledTrips));
    }

    private void truncateToServiceNetworkByMode(RoutedModeServices servicesByMode) {
        if (servicesByMode.isEmpty()) {
            return;
        }
        LOGGER.info(String.format("%sTruncating routed services to remaining service network for mode %s", LoggingUtils.routedServiceLayerPrefix((long)this.routedServicesLayer.getId()), servicesByMode.getMode()));
        this.truncateScheduledServicesToServiceNetworkByMode(servicesByMode);
        this.truncateFrequencyServicesToServiceNetworkByMode(servicesByMode);
        this.removeRoutedServicesWithoutTrips(false, servicesByMode.getMode());
    }

    protected void fireEvent(EventListener eventListener, Event event) {
        ((RoutedServicesModifierListener)eventListener).onRoutedServicesModifierEvent((RoutedServicesModificationEvent)event);
    }

    public RoutedServicesLayerModifierImpl(RoutedServicesLayerImpl routedServicesLayer) {
        this.routedServicesLayer = routedServicesLayer;
    }

    public void truncateToServiceNetwork() {
        LOGGER.info(String.format("%sTruncating routed services to remaining service network", LoggingUtils.routedServiceLayerPrefix((long)this.routedServicesLayer.getId())));
        Iterator<RoutedModeServices> iterator = this.routedServicesLayer.iterator();
        while (iterator.hasNext()) {
            RoutedModeServices servicesPerMode = iterator.next();
            this.truncateToServiceNetworkByMode(servicesPerMode);
        }
        this.removeEmptyRoutedServicesByMode(false);
        this.recreateManagedEntitiesIds();
    }

    public void consolidateIdenticallyScheduledTrips(Mode mode) {
        RoutedModeServices servicesByMode = this.routedServicesLayer.getServicesByMode(mode);
        if (servicesByMode == null || servicesByMode.isEmpty()) {
            return;
        }
        LongAdder consolidatedTripSchedules = new LongAdder();
        LongAdder removedTripSchedules = new LongAdder();
        for (RoutedService routedService : servicesByMode) {
            if (!routedService.getTripInfo().hasScheduleBasedTrips()) continue;
            HashSet schedulesToRemoveAfterConsolidation = new HashSet();
            RoutedTripsSchedule scheduleBasedTrips = routedService.getTripInfo().getScheduleBasedTrips();
            Map groupedByRelativeSchedule = scheduleBasedTrips.groupBy(rts -> rts.getRelativeLegTimingsAsStream().collect(Collectors.toList()));
            for (List schedulesToConsolidate : groupedByRelativeSchedule.values()) {
                if (schedulesToConsolidate.size() <= 1) continue;
                RoutedTripSchedule referenceTripSchedule = (RoutedTripSchedule)schedulesToConsolidate.remove(0);
                RoutedTripDepartures referenceDeparturesToSupplement = referenceTripSchedule.getDepartures();
                schedulesToConsolidate.stream().flatMap(schedule -> schedule.getDepartures().stream()).forEach(departure -> referenceDeparturesToSupplement.register(departure));
                schedulesToRemoveAfterConsolidation.addAll(schedulesToConsolidate);
                schedulesToConsolidate.stream().filter(s -> s.hasExternalId()).forEach(s -> referenceTripSchedule.appendExternalId(s.getExternalId(), CharacterUtils.COMMA));
                consolidatedTripSchedules.increment();
            }
            routedService.getTripInfo().getScheduleBasedTrips().removeAll(schedulesToRemoveAfterConsolidation);
            removedTripSchedules.add(schedulesToRemoveAfterConsolidation.size());
        }
        LOGGER.info(String.format("%sConsolidated PLANit trip schedules (mode: %s), remaining consolidated: %d, removed: %d", LoggingUtils.routedServiceLayerPrefix((long)this.routedServicesLayer.getId()), mode.getName(), consolidatedTripSchedules.intValue(), removedTripSchedules.intValue()));
    }

    public void removeEmptyRoutedServicesByMode(boolean recreateRoutedServicesManagedEntitiesIds) {
        boolean removedAnything = false;
        Iterator<RoutedModeServices> iter = this.routedServicesLayer.iterator();
        while (iter.hasNext()) {
            RoutedModeServices routedServiceForMode = iter.next();
            if (!routedServiceForMode.isEmpty()) continue;
            LOGGER.info(String.format("%sRemove routed services container for mode: %s, no services identified", LoggingUtils.routedServiceLayerPrefix((long)this.routedServicesLayer.getId()), routedServiceForMode.getMode().getName()));
            iter.remove();
            if (!removedAnything) {
                // empty if block
            }
            removedAnything = true;
        }
        if (recreateRoutedServicesManagedEntitiesIds && removedAnything) {
            this.recreateRoutedServicesIds();
        }
    }

    public void removeRoutedServicesWithoutTrips(boolean recreateRoutedServiceManagedIds, Mode ... modes) {
        boolean removedAnything = false;
        for (Mode mode : modes) {
            RoutedModeServices servicesByMode = this.routedServicesLayer.getServicesByMode(mode);
            if (servicesByMode.isEmpty()) continue;
            int before = servicesByMode.size();
            servicesByMode.removeIf(r -> !r.getTripInfo().hasAnyTrips());
            if (before == servicesByMode.size() || removedAnything) continue;
            LOGGER.info(String.format("%sRemoved %d routed services without trips (remaining: %d) for mode %s", LoggingUtils.routedServiceLayerPrefix((long)this.routedServicesLayer.getId()), before - servicesByMode.size(), servicesByMode.size(), servicesByMode.getMode()));
            removedAnything = true;
        }
        if (recreateRoutedServiceManagedIds && removedAnything) {
            this.recreateRoutedServicesIds();
        }
    }

    public void removeScheduledTripsWithoutLegs(boolean recreateManagedEntitiesIds, Mode ... modes) {
        boolean removedAnything = false;
        for (Mode mode : modes) {
            List<Pair> tripsWithEmptyLegTimings;
            RoutedModeServices servicesByMode = this.routedServicesLayer.getServicesByMode(mode);
            if (servicesByMode.isEmpty() || (tripsWithEmptyLegTimings = servicesByMode.stream().filter(r -> r.getTripInfo().hasScheduleBasedTrips()).flatMap(r -> r.getTripInfo().getScheduleBasedTrips().stream().map(rts -> Pair.of((Object)r, (Object)rts))).filter(tripSchedulePair -> !((RoutedTripSchedule)tripSchedulePair.second()).hasRelativeLegTimings()).collect(Collectors.toList())).isEmpty()) continue;
            tripsWithEmptyLegTimings.forEach(pair -> ((RoutedService)pair.first()).getTripInfo().getScheduleBasedTrips().remove((Object)((RoutedTripSchedule)pair.second())));
            LOGGER.info(String.format("%sRemoved %d trip schedules with only a single stop for mode %s", LoggingUtils.routedServiceLayerPrefix((long)this.routedServicesLayer.getId()), tripsWithEmptyLegTimings.size(), servicesByMode.getMode()));
            removedAnything = true;
        }
        if (recreateManagedEntitiesIds && removedAnything) {
            this.recreateRoutedTripsIds();
            this.recreateRoutedTripScheduleDepartureIds();
        }
    }

    public void removeDuplicateTripDepartures(boolean recreateManagedDepartureIds) {
        boolean removedAnything = false;
        for (Mode mode : this.routedServicesLayer.getSupportedModesWithServices()) {
            LongAdder removedDuplicates = new LongAdder();
            RoutedModeServices servicesByMode = this.routedServicesLayer.getServicesByMode(mode);
            if (servicesByMode.isEmpty()) continue;
            for (RoutedService routedService : servicesByMode) {
                if (!routedService.getTripInfo().hasScheduleBasedTrips()) continue;
                for (RoutedTripSchedule routedTripSchedule : routedService.getTripInfo().getScheduleBasedTrips()) {
                    Iterable toBeRemovedDepartures = null;
                    RoutedTripDeparture prevDeparture = null;
                    for (RoutedTripDeparture departure : routedTripSchedule.getDepartures().streamAscDepartureTime().collect(Collectors.toList())) {
                        if (prevDeparture != null && prevDeparture.getDepartureTime().equals((Object)departure.getDepartureTime())) {
                            toBeRemovedDepartures = toBeRemovedDepartures == null ? new ArrayList(2) : toBeRemovedDepartures;
                            toBeRemovedDepartures.add(departure);
                        }
                        prevDeparture = departure;
                    }
                    if (toBeRemovedDepartures == null) continue;
                    toBeRemovedDepartures.forEach(d -> routedTripSchedule.getDepartures().remove(d));
                    removedDuplicates.add(toBeRemovedDepartures.size());
                    removedAnything = true;
                }
            }
            if (removedDuplicates.longValue() <= 0L) continue;
            LOGGER.info(String.format("%sRemoved %d duplicate departures across all routed trip schedules for mode %s", LoggingUtils.routedServiceLayerPrefix((long)this.routedServicesLayer.getId()), removedDuplicates.longValue(), servicesByMode.getMode()));
        }
        if (recreateManagedDepartureIds && removedAnything) {
            this.recreateRoutedTripScheduleDepartureIds();
        }
    }

    public void recreateManagedEntitiesIds() {
        LOGGER.info(String.format("%sRecreating all ids managed by routed service layer", LoggingUtils.routedServiceLayerPrefix((long)this.routedServicesLayer.getId())));
        this.recreateRoutedServicesIds();
        this.recreateRoutedTripsIds();
        this.recreateRoutedTripScheduleDepartureIds();
    }

    public void recreateRoutedTripScheduleDepartureIds() {
        boolean doIdReset = true;
        Iterator<RoutedModeServices> iterator = this.routedServicesLayer.iterator();
        while (iterator.hasNext()) {
            RoutedModeServices routedModeServices = iterator.next();
            for (RoutedService entry : routedModeServices) {
                for (RoutedTripSchedule sbt : entry.getTripInfo().getScheduleBasedTrips()) {
                    sbt.getDepartures().recreateIds(doIdReset);
                    doIdReset = false;
                }
            }
        }
        this.fireEvent((Event)new ModifiedTripScheduleDepartureIdsEvent(this, this.routedServicesLayer));
    }

    public void recreateRoutedTripsIds() {
        boolean doIdReset = true;
        Iterator<RoutedModeServices> iterator = this.routedServicesLayer.iterator();
        while (iterator.hasNext()) {
            RoutedModeServices routedModeServices = iterator.next();
            for (RoutedService entry : routedModeServices) {
                if (entry.getTripInfo().getScheduleBasedTrips().getFactory().getIdGroupingToken() != entry.getTripInfo().getFrequencyBasedTrips().getFactory().getIdGroupingToken()) {
                    throw new PlanItRunTimeException("Expectation in updating ids is that all trips (frequency and scheduled) use same id token, this was found to not be the case, please adjust implementation");
                }
                entry.getTripInfo().getScheduleBasedTrips().recreateIds(doIdReset);
                doIdReset = false;
                entry.getTripInfo().getFrequencyBasedTrips().recreateIds(doIdReset);
            }
        }
        this.fireEvent((Event)new ModifiedRoutedTripIdsEvent(this, this.routedServicesLayer));
    }

    public void recreateRoutedServicesIds() {
        boolean doIdReset = true;
        Iterator<RoutedModeServices> iterator = this.routedServicesLayer.iterator();
        while (iterator.hasNext()) {
            RoutedModeServices routedModeServices = iterator.next();
            routedModeServices.recreateIds(doIdReset);
            doIdReset = false;
        }
        this.fireEvent((Event)new ModifiedRoutedServicesIdsEvent(this, this.routedServicesLayer));
    }

    public void addListener(RoutedServicesModifierListener listener) {
        super.addListener((EventListener)listener);
    }

    public void addListener(RoutedServicesModifierListener listener, RoutedServicesModifierEventType eventType) {
        super.addListener((EventListener)listener, new EventType[]{eventType});
    }

    public void removeListener(RoutedServicesModifierListener listener, RoutedServicesModifierEventType eventType) {
        super.removeListener((EventListener)listener, (EventType)eventType);
    }

    public void removeListener(RoutedServicesModifierListener listener) {
        super.removeListener((EventListener)listener);
    }
}

