/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.service.routed;

import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.goplanit.service.routed.RelativeLegTimingImpl;
import org.goplanit.service.routed.RoutedTripDeparturesImpl;
import org.goplanit.service.routed.RoutedTripImpl;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.layer.service.ServiceLegSegment;
import org.goplanit.utils.network.layer.service.ServiceNode;
import org.goplanit.utils.service.routed.RelativeLegTiming;
import org.goplanit.utils.service.routed.RoutedTripDepartures;
import org.goplanit.utils.service.routed.RoutedTripSchedule;

public class RoutedTripScheduleImpl
extends RoutedTripImpl
implements RoutedTripSchedule {
    private final RoutedTripDepartures departures;
    private final List<RelativeLegTiming> relativeLegTimings;
    private LocalTime defaultDwellTime;

    public RoutedTripScheduleImpl(IdGroupingToken tokenId) {
        super(tokenId);
        this.departures = new RoutedTripDeparturesImpl(tokenId);
        this.relativeLegTimings = new ArrayList<RelativeLegTiming>(1);
    }

    public RoutedTripScheduleImpl(RoutedTripScheduleImpl other, boolean deepCopy) {
        super(other, deepCopy);
        this.departures = deepCopy ? other.departures.deepClone() : other.departures.shallowClone();
        this.relativeLegTimings = new ArrayList<RelativeLegTiming>(other.getRelativeLegTimingsSize());
        other.relativeLegTimings.forEach(lt -> this.relativeLegTimings.add(deepCopy ? new RelativeLegTimingImpl((RelativeLegTimingImpl)lt) : lt));
    }

    @Override
    public long recreateManagedIds(IdGroupingToken tokenId) {
        long newId = RoutedTripScheduleImpl.generateId(tokenId);
        this.setId(newId);
        return newId;
    }

    public void resetChildManagedIdEntities() {
        super.resetChildManagedIdEntities();
        this.departures.reset();
    }

    @Override
    public RoutedTripScheduleImpl shallowClone() {
        return new RoutedTripScheduleImpl(this, false);
    }

    @Override
    public RoutedTripScheduleImpl deepClone() {
        return new RoutedTripScheduleImpl(this, true);
    }

    public RoutedTripDepartures getDepartures() {
        return this.departures;
    }

    public void clearRelativeLegTimings() {
        this.relativeLegTimings.clear();
    }

    public void clearDepartures() {
        this.departures.clear();
    }

    public RelativeLegTiming addRelativeLegSegmentTiming(ServiceLegSegment parentLegSegment, LocalTime duration, LocalTime dwellTime) {
        RelativeLegTimingImpl newEntry = new RelativeLegTimingImpl(parentLegSegment, duration, dwellTime);
        this.relativeLegTimings.add(newEntry);
        return newEntry;
    }

    public RelativeLegTiming getRelativeLegTiming(int index) {
        return this.relativeLegTimings.get(index);
    }

    public int getRelativeLegTimingsSize() {
        return this.relativeLegTimings.size();
    }

    public void removeLegTiming(int legTimingIndex) {
        this.relativeLegTimings.remove(legTimingIndex);
    }

    public LocalTime getDefaultDwellTime() {
        return this.defaultDwellTime;
    }

    public LocalTime updateDefaultDwellTimeToMostCommon() {
        TreeMap<LocalTime, Integer> frequency = new TreeMap<LocalTime, Integer>();
        Iterator<RelativeLegTiming> iterator = this.iterator();
        while (iterator.hasNext()) {
            RelativeLegTiming legTiming = iterator.next();
            int countIncrement = frequency.getOrDefault(legTiming.getDwellTime(), 0) + 1;
            frequency.put(legTiming.getDwellTime(), countIncrement);
        }
        LocalTime mostFrequent = (LocalTime)frequency.entrySet().stream().max(Comparator.comparing(Map.Entry::getValue)).get().getKey();
        this.setDefaultDwellTime(mostFrequent);
        Iterator<RelativeLegTiming> iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            RelativeLegTiming legTiming = iterator2.next();
            if (legTiming.getDwellTime().equals(mostFrequent)) continue;
            ((RelativeLegTimingImpl)legTiming).setDwellTime(mostFrequent);
        }
        return mostFrequent;
    }

    public void setDefaultDwellTime(LocalTime defaultDwellTime) {
        this.defaultDwellTime = defaultDwellTime;
    }

    public Iterator<RelativeLegTiming> iterator() {
        return this.relativeLegTimings.iterator();
    }

    public Set<ServiceNode> getUsedServiceNodes() {
        HashSet<ServiceNode> usedServiceNodes = new HashSet<ServiceNode>();
        Iterator<RelativeLegTiming> iterator = this.iterator();
        while (iterator.hasNext()) {
            RelativeLegTiming relLegTiming = iterator.next();
            usedServiceNodes.add(relLegTiming.getParentLegSegment().getUpstreamServiceNode());
        }
        if (usedServiceNodes.isEmpty()) {
            return usedServiceNodes;
        }
        usedServiceNodes.add(this.getRelativeLegTiming(this.getRelativeLegTimingsSize() - 1).getParentLegSegment().getDownstreamServiceNode());
        return usedServiceNodes;
    }
}

