/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.service.routed;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.goplanit.service.routed.RoutedTripImpl;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.layer.service.ServiceLegSegment;
import org.goplanit.utils.network.layer.service.ServiceNode;
import org.goplanit.utils.service.routed.RoutedTripFrequency;

public class RoutedTripFrequencyImpl
extends RoutedTripImpl
implements RoutedTripFrequency {
    private static final Logger LOGGER = Logger.getLogger(RoutedTripFrequencyImpl.class.getCanonicalName());
    public final List<ServiceLegSegment> orderedLegSegments;
    public double frequencyPerHour;

    public RoutedTripFrequencyImpl(IdGroupingToken tokenId) {
        super(tokenId);
        this.orderedLegSegments = new ArrayList<ServiceLegSegment>(1);
        this.frequencyPerHour = -1.0;
    }

    public RoutedTripFrequencyImpl(RoutedTripFrequencyImpl routedTripFrequencyImpl, boolean deepCopy) {
        super(routedTripFrequencyImpl, deepCopy);
        this.orderedLegSegments = new ArrayList<ServiceLegSegment>(routedTripFrequencyImpl.orderedLegSegments);
        this.frequencyPerHour = -1.0;
    }

    @Override
    public long recreateManagedIds(IdGroupingToken tokenId) {
        long newId = RoutedTripFrequencyImpl.generateId(tokenId);
        this.setId(newId);
        return newId;
    }

    @Override
    public RoutedTripFrequencyImpl shallowClone() {
        return new RoutedTripFrequencyImpl(this, true);
    }

    @Override
    public RoutedTripFrequencyImpl deepClone() {
        return new RoutedTripFrequencyImpl(this, false);
    }

    public void clearLegs() {
        this.orderedLegSegments.clear();
    }

    public void addLegSegment(ServiceLegSegment legSegment) {
        ServiceLegSegment lastSegment;
        if (this.hasLegSegments() && !(lastSegment = this.getLastLegSegment()).getDownstreamVertex().equals(legSegment.getUpstreamVertex())) {
            LOGGER.warning("IGNORE: Unable to add leg segment that is not contiguous to current last leg segment");
            return;
        }
        this.orderedLegSegments.add(legSegment);
    }

    public double getFrequencyPerHour() {
        return this.frequencyPerHour;
    }

    public void setFrequencyPerHour(double frequencyPerHour) {
        this.frequencyPerHour = frequencyPerHour;
    }

    public void removeLegSegment(int index) {
        if (index < 0 || index >= this.getNumberOfLegSegments()) {
            LOGGER.warning(String.format("Invalid index %d provided for removing leg segment from rotued trip frequency, ignored", index));
            return;
        }
        this.orderedLegSegments.remove(index);
    }

    public void removeAllLegSegments() {
        this.orderedLegSegments.clear();
    }

    public Iterator<ServiceLegSegment> iterator() {
        return this.orderedLegSegments.iterator();
    }

    public int getNumberOfLegSegments() {
        return this.orderedLegSegments.size();
    }

    public ServiceLegSegment getLegSegment(int index) {
        return this.orderedLegSegments.get(index);
    }

    public Set<ServiceNode> getUsedServiceNodes() {
        HashSet<ServiceNode> usedServiceNodes = new HashSet<ServiceNode>();
        Iterator<ServiceLegSegment> iterator = this.iterator();
        while (iterator.hasNext()) {
            ServiceLegSegment legSegments = iterator.next();
            usedServiceNodes.add(legSegments.getUpstreamServiceNode());
        }
        usedServiceNodes.add(this.getLastLegSegment().getDownstreamServiceNode());
        return usedServiceNodes;
    }
}

