/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.service.routed;

import java.time.LocalTime;
import java.util.function.BiConsumer;
import org.goplanit.service.routed.RoutedTripDepartureFactoryImpl;
import org.goplanit.utils.id.IdAble;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.id.ManagedIdEntitiesImpl;
import org.goplanit.utils.service.routed.RoutedTripDeparture;
import org.goplanit.utils.service.routed.RoutedTripDepartures;

public class RoutedTripDeparturesImpl
extends ManagedIdEntitiesImpl<RoutedTripDeparture>
implements RoutedTripDepartures {
    RoutedTripDepartureFactoryImpl factory;

    protected RoutedTripDeparturesImpl(IdGroupingToken tokenId) {
        super(IdAble::getId, RoutedTripDeparture.ROUTED_TRIP_DEPARTURE_ID_CLASS);
        this.factory = new RoutedTripDepartureFactoryImpl(tokenId, this);
    }

    public RoutedTripDeparturesImpl(RoutedTripDeparturesImpl other, boolean deepCopy, BiConsumer<RoutedTripDeparture, RoutedTripDeparture> mapper) {
        super((ManagedIdEntitiesImpl)other, deepCopy, mapper);
        this.factory = new RoutedTripDepartureFactoryImpl(other.factory.getIdGroupingToken(), this);
    }

    public RoutedTripDepartureFactoryImpl getFactory() {
        return this.factory;
    }

    public void allDepartLaterBy(LocalTime departureTimeIncrease) {
        this.forEach(routedTripDeparture -> routedTripDeparture.departLater(departureTimeIncrease));
    }

    public void allDepartEarlierBy(LocalTime departureTimeIncrease) {
        this.forEach(routedTripDeparture -> routedTripDeparture.departEarlier(departureTimeIncrease));
    }

    public RoutedTripDeparturesImpl shallowClone() {
        return new RoutedTripDeparturesImpl(this, false, null);
    }

    public RoutedTripDeparturesImpl deepClone() {
        return new RoutedTripDeparturesImpl(this, true, null);
    }

    public RoutedTripDeparturesImpl deepCloneWithMapping(BiConsumer<RoutedTripDeparture, RoutedTripDeparture> mapper) {
        return new RoutedTripDeparturesImpl(this, true, mapper);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Departures: ");
        this.forEach(d -> sb.append(d).append(':'));
        return sb.toString();
    }
}

