/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.service.routed;

import java.time.LocalTime;
import java.util.logging.Logger;
import org.goplanit.utils.id.ExternalIdAbleImpl;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.service.routed.RoutedTripDeparture;
import org.goplanit.utils.time.ExtendedLocalTime;

public class RoutedTripDepartureImpl
extends ExternalIdAbleImpl
implements RoutedTripDeparture {
    private static final Logger LOGGER = Logger.getLogger(RoutedTripDepartureImpl.class.getCanonicalName());
    private ExtendedLocalTime departureTime;

    protected static long generateId(IdGroupingToken tokenId) {
        return IdGenerator.generateId((IdGroupingToken)tokenId, (Class)ROUTED_TRIP_DEPARTURE_ID_CLASS);
    }

    public RoutedTripDepartureImpl(IdGroupingToken tokenId, ExtendedLocalTime departureTime) {
        super(RoutedTripDepartureImpl.generateId(tokenId));
        this.departureTime = departureTime;
    }

    public RoutedTripDepartureImpl(RoutedTripDepartureImpl routedTripDeparture, boolean deepCopy) {
        super((ExternalIdAbleImpl)routedTripDeparture);
        this.departureTime = routedTripDeparture.departureTime;
    }

    public Class<RoutedTripDeparture> getIdClass() {
        return ROUTED_TRIP_DEPARTURE_ID_CLASS;
    }

    public long recreateManagedIds(IdGroupingToken tokenId) {
        long newId = RoutedTripDepartureImpl.generateId(tokenId);
        this.setId(newId);
        return newId;
    }

    public ExtendedLocalTime getDepartureTime() {
        return this.departureTime;
    }

    public RoutedTripDepartureImpl shallowClone() {
        return new RoutedTripDepartureImpl(this, false);
    }

    public RoutedTripDepartureImpl deepClone() {
        return new RoutedTripDepartureImpl(this, true);
    }

    public void departLater(LocalTime departureTimeIncrease) {
        if (!ExtendedLocalTime.isNanosValid((long)(this.departureTime.toNanoOfExtendedDay() + departureTimeIncrease.toNanoOfDay()))) {
            LOGGER.warning(String.format("Unable to depart later by % when existing departure is at %s", new Object[]{departureTimeIncrease, this}));
        }
        this.departureTime = this.departureTime.plus(ExtendedLocalTime.of((LocalTime)departureTimeIncrease));
    }

    public void departEarlier(LocalTime departureTimeDecrease) {
        if (!ExtendedLocalTime.isNanosValid((long)(this.departureTime.toNanoOfExtendedDay() - departureTimeDecrease.toNanoOfDay()))) {
            LOGGER.warning(String.format("Unable to depart earlier by % when existing departure is at %s", new Object[]{departureTimeDecrease, this}));
        }
        this.departureTime = this.departureTime.minus(ExtendedLocalTime.of((LocalTime)departureTimeDecrease));
    }

    public String toString() {
        return String.format("Departure (id: %d xmlId: %s): %s", this.getId(), this.getXmlId(), this.getDepartureTime());
    }
}

