/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.service.routed;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import org.goplanit.service.routed.RoutedModeServicesImpl;
import org.goplanit.service.routed.modifier.RoutedServicesLayerModifierImpl;
import org.goplanit.utils.id.ExternalIdAbleImpl;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.id.ManagedIdDeepCopyMapper;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.ServiceNetworkLayer;
import org.goplanit.utils.service.routed.RoutedModeServices;
import org.goplanit.utils.service.routed.RoutedService;
import org.goplanit.utils.service.routed.RoutedServicesLayer;
import org.goplanit.utils.service.routed.modifier.RoutedServicesLayerModifier;

public class RoutedServicesLayerImpl
extends ExternalIdAbleImpl
implements RoutedServicesLayer {
    private static final Logger LOGGER = Logger.getLogger(RoutedServicesLayerImpl.class.getCanonicalName());
    private final IdGroupingToken tokenId;
    private final ServiceNetworkLayer parentLayer;
    private final RoutedServicesLayerModifierImpl layerModifier;
    private final Map<Mode, RoutedModeServices> routedServicesByMode;

    private static RoutedModeServicesImpl createRoutedModeServices(IdGroupingToken tokenId, Mode mode) {
        return new RoutedModeServicesImpl(tokenId, mode);
    }

    protected static long generateId(IdGroupingToken tokenId) {
        return IdGenerator.generateId((IdGroupingToken)tokenId, (Class)RoutedServicesLayer.ROUTED_SERVICES_LAYER_ID_CLASS);
    }

    protected RoutedModeServices removeServicesByMode(RoutedModeServices servicesByMode) {
        return this.routedServicesByMode.remove(servicesByMode);
    }

    public RoutedServicesLayerImpl(IdGroupingToken tokenId, ServiceNetworkLayer parentLayer) {
        super(RoutedServicesLayerImpl.generateId(tokenId));
        this.tokenId = tokenId;
        this.parentLayer = parentLayer;
        this.layerModifier = new RoutedServicesLayerModifierImpl(this);
        this.routedServicesByMode = new HashMap<Mode, RoutedModeServices>();
    }

    public RoutedServicesLayerImpl(RoutedServicesLayerImpl other, boolean deepCopy, ManagedIdDeepCopyMapper<RoutedService> routedServiceMapper) {
        super((ExternalIdAbleImpl)other);
        this.tokenId = other.tokenId;
        this.parentLayer = other.parentLayer;
        this.layerModifier = new RoutedServicesLayerModifierImpl(other);
        this.routedServicesByMode = new HashMap<Mode, RoutedModeServices>();
        other.routedServicesByMode.values().forEach(modeServices -> this.routedServicesByMode.put(modeServices.getMode(), deepCopy ? modeServices.deepCloneWithMapping((BiConsumer)routedServiceMapper) : modeServices.shallowClone()));
    }

    public long recreateManagedIds(IdGroupingToken tokenId) {
        long newId = RoutedServicesLayerImpl.generateId(tokenId);
        this.setId(newId);
        return newId;
    }

    public final ServiceNetworkLayer getParentLayer() {
        return this.parentLayer;
    }

    public boolean isServicesByModeEmpty(Mode mode) {
        return !this.routedServicesByMode.containsKey(mode) || this.routedServicesByMode.get(mode).isEmpty();
    }

    public RoutedModeServices getServicesByMode(Mode mode) {
        if (!this.parentLayer.supports(mode)) {
            LOGGER.warning(String.format("Unable to collect services for mode %s since it is not supported on the parent layer", mode.toString()));
        }
        if (!this.routedServicesByMode.containsKey(mode)) {
            this.routedServicesByMode.put(mode, RoutedServicesLayerImpl.createRoutedModeServices(this.tokenId, mode));
        }
        return this.routedServicesByMode.get(mode);
    }

    public RoutedServicesLayerModifier getLayerModifier() {
        return this.layerModifier;
    }

    public Iterator<RoutedModeServices> iterator() {
        return this.routedServicesByMode.values().iterator();
    }

    public void logInfo(String prefix) {
        Iterator<RoutedModeServices> iterator = this.iterator();
        while (iterator.hasNext()) {
            RoutedModeServices modeServices = iterator.next();
            if (modeServices.size() <= 0) {
                LOGGER.info(String.format("%s[mode: %s] no services present", prefix, modeServices.getMode().getXmlId()));
                continue;
            }
            int numScheduleBasedTrips = 0;
            int numFrequencyBasedTrips = 0;
            for (RoutedService entry : modeServices) {
                numScheduleBasedTrips += entry.getTripInfo().getScheduleBasedTrips().size();
                numFrequencyBasedTrips += entry.getTripInfo().getFrequencyBasedTrips().size();
            }
            LOGGER.info(String.format("%s[mode: %s] #routedServices: %d  #trip-schedules: %d  #trips-frequency: %d", prefix, modeServices.getMode().getXmlId(), modeServices.size(), numScheduleBasedTrips, numFrequencyBasedTrips));
        }
    }

    public boolean isEmpty() {
        return this.routedServicesByMode.isEmpty();
    }

    public RoutedServicesLayerImpl shallowClone() {
        return new RoutedServicesLayerImpl(this, false, null);
    }

    public RoutedServicesLayerImpl deepClone() {
        return new RoutedServicesLayerImpl(this, true, (ManagedIdDeepCopyMapper<RoutedService>)new ManagedIdDeepCopyMapper());
    }
}

