/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.service.routed;

import java.io.Serializable;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import org.goplanit.component.PlanitComponent;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.service.routed.RoutedServicesLayersImpl;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.id.ManagedIdDeepCopyMapper;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.service.routed.RoutedServicesLayer;
import org.goplanit.utils.service.routed.RoutedServicesLayers;

public class RoutedServices
extends PlanitComponent<RoutedServices>
implements Serializable {
    private static final long serialVersionUID = -5966641341343291539L;
    private static final Logger LOGGER = Logger.getLogger(RoutedServices.class.getCanonicalName());
    private ServiceNetwork parentServiceNetwork;
    private final RoutedServicesLayers layers;

    public RoutedServices(IdGroupingToken tokenId, ServiceNetwork parentServiceNetwork) {
        super(tokenId, RoutedServices.class);
        this.parentServiceNetwork = parentServiceNetwork;
        this.layers = new RoutedServicesLayersImpl(tokenId);
    }

    public RoutedServices(RoutedServices other, boolean deepCopy, BiConsumer<RoutedServicesLayer, RoutedServicesLayer> mapper) {
        super(other, deepCopy);
        this.parentServiceNetwork = other.parentServiceNetwork;
        this.layers = deepCopy ? other.layers.deepCloneWithMapping(mapper) : other.layers.shallowClone();
    }

    @Override
    public PlanitComponent<RoutedServices> shallowClone() {
        return new RoutedServices(this, false, null);
    }

    @Override
    public PlanitComponent<RoutedServices> deepClone() {
        return new RoutedServices(this, true, (BiConsumer<RoutedServicesLayer, RoutedServicesLayer>)new ManagedIdDeepCopyMapper());
    }

    @Override
    public void reset() {
        this.layers.reset();
    }

    @Override
    public Map<String, String> collectSettingsAsKeyValueMap() {
        return null;
    }

    public ServiceNetwork getParentNetwork() {
        return this.parentServiceNetwork;
    }

    public RoutedServicesLayers getLayers() {
        return this.layers;
    }

    public void logInfo(String prefix) {
        LOGGER.info(String.format("%s XML id %s (external id: %s) has %d layers", prefix, this.getXmlId(), this.getExternalId(), this.getLayers().size()));
        this.getLayers().forEach(layer -> layer.logInfo(prefix.concat(LoggingUtils.routedServiceLayerPrefix((long)layer.getId()))));
    }
}

