/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.service.routed;

import org.goplanit.service.routed.RoutedServiceTripInfoImpl;
import org.goplanit.utils.id.ExternalIdAbleImpl;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.service.routed.RoutedService;
import org.goplanit.utils.service.routed.RoutedServiceTripInfo;

public class RoutedServiceImpl
extends ExternalIdAbleImpl
implements RoutedService {
    private String name;
    private String nameDescription;
    private String serviceDescription;
    private final RoutedServiceTripInfo trips;
    private final Mode mode;

    protected static long generateId(IdGroupingToken tokenId) {
        return IdGenerator.generateId((IdGroupingToken)tokenId, (Class)RoutedService.ROUTED_SERVICE_ID_CLASS);
    }

    public RoutedServiceImpl(IdGroupingToken tokenId, Mode mode) {
        super(RoutedServiceImpl.generateId(tokenId));
        this.name = null;
        this.nameDescription = null;
        this.serviceDescription = null;
        this.mode = mode;
        this.trips = new RoutedServiceTripInfoImpl(tokenId);
    }

    public RoutedServiceImpl(RoutedServiceImpl other, boolean deepCopy) {
        super((ExternalIdAbleImpl)other);
        this.name = other.name;
        this.nameDescription = other.nameDescription;
        this.serviceDescription = other.serviceDescription;
        this.mode = other.mode;
        this.trips = deepCopy ? other.trips.deepClone() : other.trips.shallowClone();
    }

    public long recreateManagedIds(IdGroupingToken tokenId) {
        long newId = RoutedServiceImpl.generateId(tokenId);
        this.setId(newId);
        return newId;
    }

    public RoutedServiceImpl shallowClone() {
        return new RoutedServiceImpl(this, false);
    }

    public RoutedServiceImpl deepClone() {
        return new RoutedServiceImpl(this, true);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameDescription() {
        return this.nameDescription;
    }

    public void setNameDescription(String nameDescription) {
        this.nameDescription = nameDescription;
    }

    public String getServiceDescription() {
        return this.serviceDescription;
    }

    public void setServiceDescription(String serviceDescription) {
        this.serviceDescription = serviceDescription;
    }

    public RoutedServiceTripInfo getTripInfo() {
        return this.trips;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void resetChildManagedIdEntities() {
        this.trips.reset();
    }

    public String toString() {
        return String.format("id: %d XMLid: %s name: %s ", this.getId(), this.getXmlId(), this.getName());
    }
}

