/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.project;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.component.PlanitComponent;
import org.goplanit.component.PlanitComponentFactory;
import org.goplanit.cost.physical.initial.InitialMacroscopicLinkSegmentCost;
import org.goplanit.cost.physical.initial.InitialPhysicalCost;
import org.goplanit.demands.Demands;
import org.goplanit.input.InputBuilderListener;
import org.goplanit.network.LayeredNetwork;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.Network;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.path.OdPathSets;
import org.goplanit.project.ProjectDemands;
import org.goplanit.project.ProjectNetworks;
import org.goplanit.project.ProjectOdPathSets;
import org.goplanit.project.ProjectRoutedServices;
import org.goplanit.project.ProjectServiceNetworks;
import org.goplanit.project.ProjectZonings;
import org.goplanit.service.routed.RoutedServices;
import org.goplanit.supply.fundamentaldiagram.FundamentalDiagramComponent;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.network.layer.NetworkLayer;
import org.goplanit.utils.network.layer.ServiceNetworkLayer;
import org.goplanit.utils.network.layers.ServiceNetworkLayers;
import org.goplanit.utils.service.routed.RoutedServicesLayer;
import org.goplanit.utils.time.TimePeriod;
import org.goplanit.zoning.Zoning;

public class PlanItProjectInput {
    private static final Logger LOGGER = Logger.getLogger(PlanItProjectInput.class.getCanonicalName());
    private final IdGroupingToken projectGroupId;
    private final long projectId;
    protected final Map<LayeredNetwork<?, ?>, List<InitialMacroscopicLinkSegmentCost>> initialLinkSegmentCosts = new HashMap();
    protected final Collection<PlanitComponentFactory<?>> planitComponentFactories = new ArrayList();
    protected final ProjectNetworks physicalNetworks = new ProjectNetworks();
    protected final ProjectDemands demands = new ProjectDemands();
    protected final ProjectZonings zonings = new ProjectZonings();
    protected final ProjectServiceNetworks serviceNetworks = new ProjectServiceNetworks();
    protected final ProjectRoutedServices routedServices = new ProjectRoutedServices();
    protected final ProjectOdPathSets odPathSets = new ProjectOdPathSets();

    private void initialiseFactories(InputBuilderListener inputBuilderListener) {
        this.planitComponentFactories.clear();
        this.planitComponentFactories.add(new PlanitComponentFactory(InitialPhysicalCost.class));
        this.planitComponentFactories.add(new PlanitComponentFactory(Network.class.getCanonicalName()));
        this.planitComponentFactories.add(new PlanitComponentFactory(Zoning.class));
        this.planitComponentFactories.add(new PlanitComponentFactory(Demands.class));
        this.planitComponentFactories.add(new PlanitComponentFactory(RoutedServices.class));
        this.planitComponentFactories.add(new PlanitComponentFactory(FundamentalDiagramComponent.class));
        this.planitComponentFactories.forEach(factory -> factory.addListener(inputBuilderListener));
    }

    private <T extends PlanitComponent<?>> PlanitComponentFactory<T> getComponentFactory(Class<T> clazz) throws PlanItException {
        return this.planitComponentFactories.stream().filter(factory -> factory.isFactoryForDerivedClassesOf(clazz)).findFirst().orElseThrow(() -> new PlanItException("component factory unavailable for %s", new Object[]{clazz.getCanonicalName()}));
    }

    protected InitialMacroscopicLinkSegmentCost createAndRegisterInitialLinkSegmentCost(LayeredNetwork<?, ?> network, String fileName, TimePeriod timePeriod) throws PlanItException {
        PlanItException.throwIf((network == null ? 1 : 0) != 0, (String)"Physical network must be read in before initial costs can be read", (Object[])new Object[0]);
        if (!this.initialLinkSegmentCosts.containsKey(network)) {
            this.initialLinkSegmentCosts.put(network, new ArrayList());
        }
        InitialMacroscopicLinkSegmentCost initialLinkSegmentCost = (InitialMacroscopicLinkSegmentCost)this.getComponentFactory(InitialPhysicalCost.class).create(InitialMacroscopicLinkSegmentCost.class.getCanonicalName(), new Object[]{this.projectGroupId}, fileName, network, timePeriod);
        if (timePeriod != null) {
            LOGGER.info(LoggingUtils.projectPrefix((long)this.projectId) + LoggingUtils.timePeriodPrefix((TimePeriod)timePeriod) + "populated initial link segment costs");
        } else {
            LOGGER.info(LoggingUtils.projectPrefix((long)this.projectId) + "populated initial link segment costs");
        }
        this.initialLinkSegmentCosts.get(network).add(initialLinkSegmentCost);
        return initialLinkSegmentCost;
    }

    public PlanItProjectInput(long projectId, IdGroupingToken projectGroupId, InputBuilderListener inputBuilderListener) {
        this.projectId = projectId;
        this.projectGroupId = projectGroupId;
        this.initialiseFactories(inputBuilderListener);
    }

    public LayeredNetwork<?, ?> createAndRegisterInfrastructureNetwork(String infrastructureNetworkType) throws PlanItException {
        LOGGER.info(LoggingUtils.projectPrefix((long)this.projectId) + "populating network");
        Network theNetwork = (Network)this.getComponentFactory(Network.class).create(infrastructureNetworkType, new Object[]{this.projectGroupId});
        if (!(theNetwork instanceof LayeredNetwork)) {
            throw new PlanItException("we currently only support networks derived from InfrastructureNetwork");
        }
        LayeredNetwork infrastructureNetwork = (LayeredNetwork)theNetwork;
        String prefix = LoggingUtils.projectPrefix((long)this.projectId) + LoggingUtils.networkPrefix((long)infrastructureNetwork.getId());
        LOGGER.info(String.format("%s#modes: %d", prefix, infrastructureNetwork.getModes().size()));
        infrastructureNetwork.logInfo(prefix);
        this.physicalNetworks.register(infrastructureNetwork);
        return infrastructureNetwork;
    }

    public Zoning createAndRegisterZoning(LayeredNetwork<?, ?> infrastructureNetwork) throws PlanItException {
        PlanItException.throwIf((infrastructureNetwork == null ? 1 : 0) != 0, (String)"The physical network must be defined before definition of zones can begin", (Object[])new Object[0]);
        LOGGER.info(LoggingUtils.projectPrefix((long)this.projectId) + "populating zoning");
        Zoning zoning = (Zoning)this.getComponentFactory(Zoning.class).create(Zoning.class.getCanonicalName(), new Object[]{this.projectGroupId, infrastructureNetwork.getNetworkGroupingTokenId()}, infrastructureNetwork);
        this.zonings.register(zoning);
        return zoning;
    }

    public Demands createAndRegisterDemands(Zoning zoning, LayeredNetwork<?, ?> network) throws PlanItException {
        PlanItException.throwIf((zoning == null ? 1 : 0) != 0, (String)"Zones must be defined before definition of demands can begin", (Object[])new Object[0]);
        PlanItException.throwIf((network == null ? 1 : 0) != 0, (String)"network must be defined before definition of demands can begin", (Object[])new Object[0]);
        LOGGER.info(LoggingUtils.projectPrefix((long)this.projectId) + "populating demands");
        Demands demands = (Demands)this.getComponentFactory(Demands.class).create(Demands.class.getCanonicalName(), new Object[]{this.projectGroupId}, zoning, network);
        this.demands.register(demands);
        return demands;
    }

    public ServiceNetwork createAndRegisterServiceNetwork(MacroscopicNetwork network) throws PlanItException {
        PlanItException.throwIf((network == null ? 1 : 0) != 0, (String)"Physical network must be defined before definition of service network can begin", (Object[])new Object[0]);
        LOGGER.info(String.format("%spopulating service network with parent physical network %s", LoggingUtils.projectPrefix((long)this.projectId), network.getXmlId()));
        Network theNetwork = (Network)this.getComponentFactory(Network.class).create(ServiceNetwork.class.getCanonicalName(), new Object[]{this.projectGroupId, network});
        if (!(theNetwork instanceof ServiceNetwork)) {
            throw new PlanItException("we currently only support ServiceNetwork derived classes when creating service networks");
        }
        ServiceNetwork serviceNetwork = (ServiceNetwork)theNetwork;
        String prefix = LoggingUtils.projectPrefix((long)this.projectId) + LoggingUtils.serviceNetworkPrefix((long)serviceNetwork.getId());
        if (((ServiceNetworkLayers)serviceNetwork.getTransportLayers()).isEmpty()) {
            LOGGER.warning(String.format("Created service network for parent network %s is empty", network.getXmlId()));
        } else {
            LOGGER.info(String.format("%s#modes: %d", prefix, serviceNetwork.getModes().size()));
            for (ServiceNetworkLayer networkLayer : (ServiceNetworkLayers)serviceNetwork.getTransportLayers()) {
                networkLayer.logInfo(prefix);
            }
        }
        this.serviceNetworks.register(serviceNetwork);
        return serviceNetwork;
    }

    public RoutedServices createAndRegisterRoutedServices(ServiceNetwork serviceNetwork) throws PlanItException {
        PlanItException.throwIf((serviceNetwork == null ? 1 : 0) != 0, (String)"Parent service network must be defined before definition of routed services can begin", (Object[])new Object[0]);
        LOGGER.info(String.format("%spopulating routed services with parent service network %s", LoggingUtils.projectPrefix((long)this.projectId), serviceNetwork.getXmlId()));
        RoutedServices routedServices = (RoutedServices)this.getComponentFactory(RoutedServices.class).create(RoutedServices.class.getCanonicalName(), new Object[]{this.projectGroupId, serviceNetwork});
        String prefix = LoggingUtils.projectPrefix((long)this.projectId) + LoggingUtils.routedServicesPrefix((long)routedServices.getId());
        for (RoutedServicesLayer layer : routedServices.getLayers()) {
            layer.logInfo(prefix);
        }
        this.routedServices.register(routedServices);
        return routedServices;
    }

    public OdPathSets createAndRegisterOdPathSets(NetworkLayer networkLayer, Zoning zoning, String odPathSetInputPath) throws PlanItException {
        PlanItException.throwIf((zoning == null ? 1 : 0) != 0, (String)"Zones must be defined before definition of od path sets can proceed", (Object[])new Object[0]);
        PlanItException.throwIf((networkLayer == null ? 1 : 0) != 0, (String)"Physical network must be defined before of od path sets can proceed", (Object[])new Object[0]);
        LOGGER.info(LoggingUtils.projectPrefix((long)this.projectId) + "populating od path sets");
        OdPathSets odPathSets = (OdPathSets)this.getComponentFactory(OdPathSets.class).create(OdPathSets.class.getCanonicalName(), new Object[]{this.projectGroupId}, odPathSetInputPath);
        String prefix = LoggingUtils.projectPrefix((long)this.projectId) + LoggingUtils.odPathSetsPrefix((long)odPathSets.getId());
        LOGGER.info(String.format("%s#od path sets: %d", prefix, odPathSets.getNumberOfOdPathSets()));
        this.odPathSets.register(odPathSets);
        return odPathSets;
    }

    public InitialMacroscopicLinkSegmentCost createAndRegisterInitialLinkSegmentCost(LayeredNetwork<?, ?> network, String fileName) throws PlanItException {
        return this.createAndRegisterInitialLinkSegmentCost(network, fileName, null);
    }

    public List<InitialMacroscopicLinkSegmentCost> getInitialLinkSegmentCost(LayeredNetwork<?, ?> network) {
        return this.initialLinkSegmentCosts.get(network);
    }
}

