/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.path.choice;

import java.util.logging.Logger;
import org.goplanit.component.PlanitComponentBuilder;
import org.goplanit.component.PlanitComponentFactory;
import org.goplanit.input.InputBuilderListener;
import org.goplanit.path.choice.PathChoice;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;

public abstract class PathChoiceBuilder<T extends PathChoice>
extends PlanitComponentBuilder<T> {
    protected static final Logger LOGGER = Logger.getLogger(PathChoiceBuilder.class.getCanonicalName());

    protected T createPathChoiceInstance() throws PlanItException {
        String pathChoiceClassName = this.getClassToBuild().getClass().getCanonicalName();
        PlanitComponentFactory pathChoiceFactory = new PlanitComponentFactory(pathChoiceClassName);
        PathChoice pathChoice = (PathChoice)pathChoiceFactory.create(pathChoiceClassName, new Object[]{this.getGroupIdToken()});
        PlanItException.throwIf((!(pathChoice instanceof PathChoice) ? 1 : 0) != 0, (String)"not a valid path choice type", (Object[])new Object[0]);
        return (T)pathChoice;
    }

    protected abstract void buildSubComponents(T var1) throws PlanItException;

    protected PathChoiceBuilder(Class<T> pathChoiceClass, IdGroupingToken projectToken, InputBuilderListener inputBuilderListener) throws PlanItException {
        super(pathChoiceClass, projectToken, inputBuilderListener);
    }

    public T build() throws PlanItException {
        T pathChoice = this.createPathChoiceInstance();
        this.buildSubComponents(pathChoice);
        this.getConfigurator().configure(pathChoice);
        return pathChoice;
    }
}

