/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.path;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.path.SimpleDirectedPath;

public class SimpleDirectedPathImpl
implements SimpleDirectedPath {
    private static final Logger LOGGER = Logger.getLogger(SimpleDirectedPathImpl.class.getCanonicalName());
    private final Deque<EdgeSegment> path;

    protected SimpleDirectedPathImpl() {
        this.path = new ArrayDeque<EdgeSegment>();
    }

    protected SimpleDirectedPathImpl(SimpleDirectedPathImpl other) {
        this.path = new ArrayDeque<EdgeSegment>(other.path);
    }

    protected SimpleDirectedPathImpl(Deque<? extends EdgeSegment> pathEdgeSegments) {
        this.path = pathEdgeSegments;
    }

    public Iterator<EdgeSegment> iterator() {
        return this.path.iterator();
    }

    public long size() {
        return this.path.size();
    }

    public boolean containsSubPath(Collection<? extends EdgeSegment> subPath) {
        return this.containsSubPath(subPath.iterator());
    }

    public boolean containsSubPath(Iterator<? extends EdgeSegment> subPathIter) {
        if (subPathIter == null && subPathIter.hasNext()) {
            return false;
        }
        EdgeSegment subPathSegment = subPathIter.next();
        boolean started = false;
        for (EdgeSegment edgeSegment : this.path) {
            if (started) {
                subPathSegment = subPathIter.next();
            }
            if (edgeSegment.idEquals((Object)subPathSegment)) {
                started = true;
            } else if (started) {
                started = false;
                break;
            }
            if (subPathIter.hasNext()) continue;
            break;
        }
        return started && !subPathIter.hasNext();
    }

    public EdgeSegment getFirstSegment() {
        return this.path.getFirst();
    }

    public EdgeSegment getLastSegment() {
        return this.path.getLast();
    }

    public void append(EdgeSegment ... edgeSegments) {
        Arrays.stream(edgeSegments).forEach(e -> this.path.add((EdgeSegment)e));
    }

    public void prepend(EdgeSegment ... edgeSegments) {
        Arrays.stream(edgeSegments).forEach(e -> this.path.push((EdgeSegment)e));
    }

    public int hashCode() {
        return StreamSupport.stream(this.spliterator(), false).collect(Collectors.toList()).hashCode();
    }
}

