/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.path;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import org.goplanit.component.PlanitComponent;
import org.goplanit.od.path.OdPathMatrix;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.zoning.Zoning;

public class OdPathSets
extends PlanitComponent<OdPathSets>
implements Serializable {
    private static final long serialVersionUID = -8742549499023004121L;
    protected final TreeMap<Long, OdPathMatrix> odPathMatrices = new TreeMap();

    public OdPathSets(IdGroupingToken groupId) {
        super(groupId, OdPathSets.class);
    }

    public OdPathSets(OdPathSets other, boolean deepCopy) {
        super(other, deepCopy);
        other.odPathMatrices.entrySet().forEach(entry -> this.odPathMatrices.put((Long)entry.getKey(), deepCopy ? ((OdPathMatrix)entry.getValue()).deepClone() : (OdPathMatrix)entry.getValue()));
    }

    public int getNumberOfOdPathSets() {
        return this.odPathMatrices.size();
    }

    public OdPathMatrix createAndRegisterOdPathMatrix(Zoning zoning) {
        OdPathMatrix newOdPathMatrix = new OdPathMatrix(this.getIdGroupingToken(), zoning.getOdZones());
        this.odPathMatrices.put(newOdPathMatrix.getId(), newOdPathMatrix);
        return newOdPathMatrix;
    }

    public void registerOdPathMatrix(OdPathMatrix odPathMatrix) {
        this.odPathMatrices.put(odPathMatrix.getId(), odPathMatrix);
    }

    public Boolean hasRegisteredOdMatrices() {
        return !this.odPathMatrices.isEmpty();
    }

    public OdPathMatrix getFirstOdPathMatrix() {
        return this.hasRegisteredOdMatrices() != false ? this.odPathMatrices.firstEntry().getValue() : null;
    }

    public OdPathSets shallowClone() {
        return new OdPathSets(this, false);
    }

    public OdPathSets deepClone() {
        return new OdPathSets(this, true);
    }

    @Override
    public void reset() {
        this.odPathMatrices.clear();
    }

    @Override
    public Map<String, String> collectSettingsAsKeyValueMap() {
        return null;
    }
}

