/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.path;

import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.logging.Logger;
import org.goplanit.path.SimpleDirectedPathImpl;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.id.ExternalIdAbleImpl;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.path.ManagedDirectedPath;

public class ManagedDirectedPathImpl
extends ExternalIdAbleImpl
implements ManagedDirectedPath {
    private static final Logger LOGGER = Logger.getLogger(ManagedDirectedPathImpl.class.getCanonicalName());
    private final SimpleDirectedPathImpl path;

    protected static long generateId(IdGroupingToken groupId) {
        return IdGenerator.generateId((IdGroupingToken)groupId, (Class)ManagedDirectedPath.PATH_ID_CLASS);
    }

    protected ManagedDirectedPathImpl(IdGroupingToken groupId) {
        super(ManagedDirectedPathImpl.generateId(groupId));
        this.path = new SimpleDirectedPathImpl();
    }

    protected ManagedDirectedPathImpl(IdGroupingToken groupId, Deque<? extends EdgeSegment> pathEdgeSegments) {
        super(ManagedDirectedPathImpl.generateId(groupId));
        this.path = new SimpleDirectedPathImpl(pathEdgeSegments);
    }

    protected ManagedDirectedPathImpl(ManagedDirectedPathImpl other, boolean deepCopy) {
        super((ExternalIdAbleImpl)other);
        this.path = new SimpleDirectedPathImpl(other.path);
    }

    public Iterator<EdgeSegment> iterator() {
        return this.path.iterator();
    }

    public long recreateManagedIds(IdGroupingToken tokenId) {
        long newId = ManagedDirectedPathImpl.generateId(tokenId);
        this.setId(newId);
        return newId;
    }

    public long size() {
        return this.path.size();
    }

    public boolean containsSubPath(Collection<? extends EdgeSegment> subPath) {
        return this.path.containsSubPath(subPath);
    }

    public boolean containsSubPath(Iterator<? extends EdgeSegment> subPath) {
        return this.path.containsSubPath(subPath);
    }

    public EdgeSegment getFirstSegment() {
        return this.path.getFirstSegment();
    }

    public EdgeSegment getLastSegment() {
        return this.path.getLastSegment();
    }

    public ManagedDirectedPathImpl shallowClone() {
        return new ManagedDirectedPathImpl(this, false);
    }

    public ManagedDirectedPathImpl deepClone() {
        return new ManagedDirectedPathImpl(this, true);
    }
}

