/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.output.formatter;

import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.goplanit.data.MultiKeyPlanItData;
import org.goplanit.network.layer.macroscopic.MacroscopicLinkSegmentImpl;
import org.goplanit.od.path.OdPathMatrix;
import org.goplanit.od.skim.OdSkimMatrix;
import org.goplanit.output.adapter.MacroscopicLinkOutputTypeAdapter;
import org.goplanit.output.adapter.OdOutputTypeAdapter;
import org.goplanit.output.adapter.OutputAdapter;
import org.goplanit.output.adapter.PathOutputTypeAdapter;
import org.goplanit.output.configuration.OutputConfiguration;
import org.goplanit.output.configuration.OutputTypeConfiguration;
import org.goplanit.output.configuration.PathOutputTypeConfiguration;
import org.goplanit.output.enums.OdSkimSubOutputType;
import org.goplanit.output.enums.OutputType;
import org.goplanit.output.enums.OutputTypeEnum;
import org.goplanit.output.enums.PathOutputIdentificationType;
import org.goplanit.output.enums.SubOutputTypeEnum;
import org.goplanit.output.formatter.BaseOutputFormatter;
import org.goplanit.output.formatter.MemoryOutputIterator;
import org.goplanit.output.property.OutputProperty;
import org.goplanit.output.property.OutputPropertyType;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.od.OdDataIterator;
import org.goplanit.utils.path.ManagedDirectedPath;
import org.goplanit.utils.time.TimePeriod;
import org.goplanit.utils.unit.VehiclesUnit;

public class MemoryOutputFormatter
extends BaseOutputFormatter {
    private static final Logger LOGGER = Logger.getLogger(MacroscopicLinkSegmentImpl.class.getCanonicalName());
    private MultiKeyMap<Object, MultiKeyPlanItData> timeModeOutputTypeIterationDataMap;
    public MemoryOutputIterator iterator;

    private Object[] getValues(OutputProperty[] outputPropertiesArray, Function<OutputProperty, Object> getValueFromAdapter) throws PlanItException {
        Object[] values = new Object[outputPropertiesArray.length];
        for (int i = 0; i < outputPropertiesArray.length; ++i) {
            values[i] = getValueFromAdapter.apply(outputPropertiesArray[i]);
            if (!(values[i] instanceof PlanItException)) continue;
            throw (PlanItException)((Object)values[i]);
        }
        return values;
    }

    private void updateOutputAndKeyValues(MultiKeyPlanItData multiKeyPlanItData, OutputProperty[] outputProperties, OutputProperty[] outputKeys, Function<OutputProperty, Object> getValueFromAdapter) throws PlanItException {
        Object[] outputValues = this.getValues(outputProperties, getValueFromAdapter);
        Object[] keyValues = this.getValues(outputKeys, getValueFromAdapter);
        multiKeyPlanItData.putRow(outputValues, keyValues);
    }

    private void updateOutputAndKeyValuesForLink(MultiKeyPlanItData multiKeyPlanItData, OutputProperty[] outputProperties, OutputProperty[] outputKeys, MacroscopicLinkSegment linkSegment, MacroscopicLinkOutputTypeAdapter linkOutputTypeAdapter, Mode mode, TimePeriod timePeriod) throws PlanItException {
        Optional<Boolean> flowPositive = linkOutputTypeAdapter.isFlowPositive(linkSegment, mode);
        flowPositive.orElseThrow(() -> new PlanItException("unable to determine if flow is positive on link segment"));
        if (flowPositive.get().booleanValue()) {
            this.updateOutputAndKeyValues(multiKeyPlanItData, outputProperties, outputKeys, label -> linkOutputTypeAdapter.getLinkSegmentOutputPropertyValue((OutputProperty)label, linkSegment, mode, timePeriod).get());
        }
    }

    private void updateOutputAndKeyValuesForOd(MultiKeyPlanItData multiKeyPlanItData, OutputProperty[] outputProperties, OutputProperty[] outputKeys, OdDataIterator<?> odDataIterator, OdOutputTypeAdapter odOutputTypeAdapter, Mode mode, TimePeriod timePeriod) throws PlanItException {
        this.updateOutputAndKeyValues(multiKeyPlanItData, outputProperties, outputKeys, label -> odOutputTypeAdapter.getOdOutputPropertyValue((OutputProperty)label, odDataIterator, mode, timePeriod).get());
    }

    private void updateOutputAndKeyValuesForPath(MultiKeyPlanItData multiKeyPlanItData, OutputProperty[] outputProperties, OutputProperty[] outputKeys, OdDataIterator<? extends ManagedDirectedPath> odPathIterator, PathOutputTypeAdapter pathOutputTypeAdapter, Mode mode, TimePeriod timePeriod, PathOutputIdentificationType pathIdType) throws PlanItException {
        this.updateOutputAndKeyValues(multiKeyPlanItData, outputProperties, outputKeys, label -> pathOutputTypeAdapter.getPathOutputPropertyValue((OutputProperty)label, odPathIterator, mode, timePeriod, pathIdType).get());
    }

    @Override
    protected void writeSimulationResultsForCurrentTimePeriod(OutputConfiguration outputConfiguration, OutputTypeConfiguration outputTypeConfiguration, OutputTypeEnum currentOutputType, OutputAdapter outputAdapter, Set<Mode> modes, TimePeriod timePeriod, int iterationIndex) throws PlanItException {
        LOGGER.warning("memory Output for OutputType SIMULATION has not been implemented yet");
    }

    @Override
    protected void writeGeneralResultsForCurrentTimePeriod(OutputConfiguration outputConfiguration, OutputTypeConfiguration outputTypeConfiguration, OutputTypeEnum currentOutputType, OutputAdapter outputAdapter, Set<Mode> modes, TimePeriod timePeriod, int iterationIndex) throws PlanItException {
        LOGGER.warning("memory Output for OutputType GENERAL has not been implemented yet");
    }

    @Override
    protected void writeLinkResultsForCurrentTimePeriod(OutputConfiguration outputConfiguration, OutputTypeConfiguration outputTypeConfiguration, OutputTypeEnum currentOutputType, OutputAdapter outputAdapter, Set<Mode> modes, TimePeriod timePeriod, int iterationIndex) throws PlanItException {
        PlanItException.throwIf((!(currentOutputType instanceof OutputType) && (OutputType)currentOutputType == OutputType.LINK ? 1 : 0) != 0, (String)"currentOutputTypeEnum is not compatible with outputTypeconfiguration", (Object[])new Object[0]);
        OutputType outputType = (OutputType)currentOutputType;
        OutputProperty[] outputProperties = (OutputProperty[])this.outputValueProperties.get(outputType);
        OutputProperty[] outputKeys = (OutputProperty[])this.outputKeyProperties.get(outputType);
        MacroscopicLinkOutputTypeAdapter linkOutputTypeAdapter = (MacroscopicLinkOutputTypeAdapter)outputAdapter.getOutputTypeAdapter(outputType);
        for (Mode mode : modes) {
            VehiclesUnit.updatePcuToVehicleFactor((double)(1.0 / mode.getPcu()));
            MultiKeyPlanItData multiKeyPlanItData = new MultiKeyPlanItData(outputKeys, outputProperties);
            Optional<Long> networkLayerId = linkOutputTypeAdapter.getInfrastructureLayerIdForMode(mode);
            networkLayerId.orElseThrow(() -> new PlanItException("unable to determine if layer id for mode"));
            for (MacroscopicLinkSegment linkSegment : linkOutputTypeAdapter.getPhysicalLinkSegments(networkLayerId.get())) {
                Optional<Boolean> flowPositive = linkOutputTypeAdapter.isFlowPositive(linkSegment, mode);
                flowPositive.orElseThrow(() -> new PlanItException("unable to determine if flow is positive on link segment"));
                if (!outputConfiguration.isPersistZeroFlow() && !flowPositive.get().booleanValue()) continue;
                this.updateOutputAndKeyValuesForLink(multiKeyPlanItData, outputProperties, outputKeys, linkSegment, linkOutputTypeAdapter, mode, timePeriod);
            }
            this.timeModeOutputTypeIterationDataMap.put((Object)mode, (Object)timePeriod, (Object)iterationIndex, (Object)outputType, (Object)multiKeyPlanItData);
        }
    }

    @Override
    protected void writeOdResultsForCurrentTimePeriod(OutputConfiguration outputConfiguration, OutputTypeConfiguration outputTypeConfiguration, OutputTypeEnum currentOutputType, OutputAdapter outputAdapter, Set<Mode> modes, TimePeriod timePeriod, int iterationIndex) throws PlanItException {
        PlanItException.throwIf((!(currentOutputType instanceof SubOutputTypeEnum) || !((SubOutputTypeEnum)currentOutputType instanceof OdSkimSubOutputType) ? 1 : 0) != 0, (String)"currentOutputTypeEnum is not compatible with outputTypeconfiguration", (Object[])new Object[0]);
        OdSkimSubOutputType subOutputType = (OdSkimSubOutputType)currentOutputType;
        OutputType outputType = outputTypeConfiguration.getOutputType();
        OutputProperty OD_COST_PROPERTY = OutputProperty.of(OutputPropertyType.OD_COST);
        OutputProperty[] outputProperties = (OutputProperty[])this.outputValueProperties.get(outputType);
        OutputProperty[] outputKeys = (OutputProperty[])this.outputKeyProperties.get(outputType);
        OdOutputTypeAdapter odOutputTypeAdapter = (OdOutputTypeAdapter)outputAdapter.getOutputTypeAdapter(outputType);
        for (Mode mode : modes) {
            VehiclesUnit.updatePcuToVehicleFactor((double)(1.0 / mode.getPcu()));
            MultiKeyPlanItData multiKeyPlanItData = new MultiKeyPlanItData(outputKeys, outputProperties);
            Optional<OdSkimMatrix> odSkimMatrix = odOutputTypeAdapter.getOdSkimMatrix(subOutputType, mode);
            odSkimMatrix.orElseThrow(() -> new PlanItException("unable to retrieve od skim matrix"));
            OdSkimMatrix.OdSkimMatrixIterator odIterator = odSkimMatrix.get().iterator();
            while (odIterator.hasNext()) {
                odIterator.next();
                Optional<?> cost = odOutputTypeAdapter.getOdOutputPropertyValue(OD_COST_PROPERTY, (OdDataIterator<?>)odIterator, mode, timePeriod);
                cost.orElseThrow(() -> new PlanItException("cost could not be retrieved when persisting"));
                if (!outputConfiguration.isPersistZeroFlow() && !((Double)cost.get() > 1.0E-6)) continue;
                this.updateOutputAndKeyValuesForOd(multiKeyPlanItData, outputProperties, outputKeys, (OdDataIterator<?>)odIterator, odOutputTypeAdapter, mode, timePeriod);
            }
            this.timeModeOutputTypeIterationDataMap.put((Object)mode, (Object)timePeriod, (Object)iterationIndex, (Object)outputType, (Object)multiKeyPlanItData);
        }
    }

    @Override
    protected void writePathResultsForCurrentTimePeriod(OutputConfiguration outputConfiguration, OutputTypeConfiguration outputTypeConfiguration, OutputTypeEnum currentOutputType, OutputAdapter outputAdapter, Set<Mode> modes, TimePeriod timePeriod, int iterationIndex) throws PlanItException {
        PlanItException.throwIf((!(currentOutputType instanceof OutputType) && (OutputType)currentOutputType == OutputType.PATH ? 1 : 0) != 0, (String)"currentOutputTypeEnum is not compatible with outputTypeconfiguration", (Object[])new Object[0]);
        OutputType outputType = (OutputType)currentOutputType;
        OutputProperty[] outputProperties = (OutputProperty[])this.outputValueProperties.get(outputType);
        OutputProperty[] outputKeys = (OutputProperty[])this.outputKeyProperties.get(outputType);
        PathOutputTypeAdapter pathOutputTypeAdapter = (PathOutputTypeAdapter)outputAdapter.getOutputTypeAdapter(outputType);
        PathOutputTypeConfiguration pathOutputTypeConfiguration = (PathOutputTypeConfiguration)outputTypeConfiguration;
        for (Mode mode : modes) {
            VehiclesUnit.updatePcuToVehicleFactor((double)(1.0 / mode.getPcu()));
            MultiKeyPlanItData multiKeyPlanItData = new MultiKeyPlanItData(outputKeys, outputProperties);
            Optional<OdPathMatrix> odPathMatrix = pathOutputTypeAdapter.getOdPathMatrix(mode);
            odPathMatrix.orElseThrow(() -> new PlanItException("od path matrix could not be retrieved when persisting"));
            OdPathMatrix.OdPathMatrixIterator odPathIterator = odPathMatrix.get().iterator();
            while (odPathIterator.hasNext()) {
                odPathIterator.next();
                if (!outputConfiguration.isPersistZeroFlow() && odPathIterator.getCurrentValue() == null) continue;
                this.updateOutputAndKeyValuesForPath(multiKeyPlanItData, outputProperties, outputKeys, odPathIterator, pathOutputTypeAdapter, mode, timePeriod, pathOutputTypeConfiguration.getPathIdentificationType());
            }
            this.timeModeOutputTypeIterationDataMap.put((Object)mode, (Object)timePeriod, (Object)iterationIndex, (Object)outputType, (Object)multiKeyPlanItData);
        }
    }

    public MemoryOutputFormatter(IdGroupingToken groupId) {
        super(groupId);
    }

    public Object getOutputDataValue(Mode mode, TimePeriod timePeriod, Integer iterationIndex, OutputType outputType, OutputPropertyType outputProperty, Object[] keyValues) throws PlanItException {
        MultiKeyPlanItData multiKeyPlanItData = (MultiKeyPlanItData)this.timeModeOutputTypeIterationDataMap.get((Object)mode, (Object)timePeriod, (Object)iterationIndex, (Object)outputType);
        return multiKeyPlanItData.getRowValue(outputProperty, keyValues);
    }

    @Override
    public void initialiseBeforeSimulation(OutputConfiguration outputConfiguration, long runId) throws PlanItException {
        this.timeModeOutputTypeIterationDataMap = new MultiKeyMap();
    }

    @Override
    public void finaliseAfterSimulation(OutputConfiguration outputConfiguration, OutputAdapter outputAdapter) throws PlanItException {
    }

    public OutputProperty[] getOutputKeyProperties(OutputType outputType) {
        return (OutputProperty[])this.outputKeyProperties.get(outputType);
    }

    public OutputProperty[] getOutputValueProperties(OutputType outputType) {
        return (OutputProperty[])this.outputValueProperties.get(outputType);
    }

    public int getLastIteration() {
        Set keySet = this.timeModeOutputTypeIterationDataMap.keySet();
        int lastIteration = 0;
        for (MultiKey multiKey : keySet) {
            Object[] keys = multiKey.getKeys();
            Integer iteration = (Integer)keys[2];
            lastIteration = Math.max(lastIteration, iteration);
        }
        return lastIteration;
    }

    @Override
    public boolean canHandleMultipleIterations() {
        return true;
    }

    public MemoryOutputIterator getIterator(Mode mode, TimePeriod timePeriod, Integer iterationIndex, OutputType outputType) {
        if (mode == null) {
            LOGGER.warning("IGNORE: mode null when obtaining memory output iterator");
            return null;
        }
        if (timePeriod == null) {
            LOGGER.warning("IGNORE: time period null when obtaining memory output iterator");
            return null;
        }
        if (iterationIndex == null) {
            LOGGER.warning("IGNORE: iteration null when obtaining memory output iterator");
            return null;
        }
        if (outputType == null) {
            LOGGER.warning("IGNORE: output type null when obtaining memory output iterator");
            return null;
        }
        MultiKeyPlanItData multiKeyPlanItData = (MultiKeyPlanItData)this.timeModeOutputTypeIterationDataMap.get((Object)mode, (Object)timePeriod, (Object)iterationIndex, (Object)outputType);
        MemoryOutputIterator memoryOutputIterator = new MemoryOutputIterator(multiKeyPlanItData);
        return memoryOutputIterator;
    }

    public int getPositionOfOutputValueProperty(OutputType outputType, OutputPropertyType outputValueProperty) throws PlanItException {
        Set keySet = this.timeModeOutputTypeIterationDataMap.keySet();
        for (MultiKey multiKey : keySet) {
            Object[] keys = multiKey.getKeys();
            Mode mode1 = (Mode)keys[0];
            TimePeriod timePeriod1 = (TimePeriod)keys[1];
            Integer iterationIndex1 = (Integer)keys[2];
            MultiKeyPlanItData multiKeyPlanItData = (MultiKeyPlanItData)this.timeModeOutputTypeIterationDataMap.get((Object)mode1, (Object)timePeriod1, (Object)iterationIndex1, (Object)outputType);
            OutputType outputType1 = (OutputType)keys[3];
            if (!outputType1.equals(outputType)) continue;
            return multiKeyPlanItData.getPositionOfOutputValueProperty(outputValueProperty);
        }
        throw new PlanItException("Value property " + outputType.name() + " could not be found in the MemoryOutputFormatter");
    }

    public int getPositionOfOutputKeyProperty(OutputType outputType, OutputPropertyType outputKeyProperty) throws PlanItException {
        Set keySet = this.timeModeOutputTypeIterationDataMap.keySet();
        for (MultiKey multiKey : keySet) {
            Object[] keys = multiKey.getKeys();
            Mode mode1 = (Mode)keys[0];
            TimePeriod timePeriod1 = (TimePeriod)keys[1];
            Integer iterationIndex1 = (Integer)keys[2];
            MultiKeyPlanItData multiKeyPlanItData = (MultiKeyPlanItData)this.timeModeOutputTypeIterationDataMap.get((Object)mode1, (Object)timePeriod1, (Object)iterationIndex1, (Object)outputType);
            OutputType outputType1 = (OutputType)keys[3];
            if (!outputType1.equals(outputType)) continue;
            return multiKeyPlanItData.getPositionOfOutputKeyProperty(outputKeyProperty);
        }
        throw new PlanItException("Key property " + outputType.name() + " could not be found in the MemoryOutputFormatter");
    }
}

