/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.output.formatter;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Logger;
import org.goplanit.output.enums.OutputType;
import org.goplanit.output.formatter.BaseOutputFormatter;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.time.TimePeriod;

public abstract class FileOutputFormatter
extends BaseOutputFormatter {
    private static final Logger LOGGER = Logger.getLogger(FileOutputFormatter.class.getCanonicalName());

    protected FileOutputFormatter(IdGroupingToken groupId) {
        super(groupId);
    }

    protected String generateAbsoluteOutputFileName(String outputDirectory, String nameRoot, String nameExtension, TimePeriod timePeriod, OutputType outputType, long runId, int iteration) throws PlanItException {
        try {
            Path outputDirPath = Path.of(outputDirectory, new String[0]).toAbsolutePath();
            if (!Files.isDirectory(outputDirPath, new LinkOption[0])) {
                Files.createDirectories(outputDirPath, new FileAttribute[0]);
            }
            String nameRootNoSpace = nameRoot.replaceAll(" ", "_");
            String newFileName = null;
            newFileName = timePeriod == null ? (iteration == -1 ? Path.of(outputDirPath.toString(), outputType.value() + "_RunId_" + runId + "_" + nameRootNoSpace + nameExtension).toString() : Path.of(outputDirPath.toString(), outputType.value() + "_RunId_" + runId + "_" + nameRootNoSpace + "_" + iteration + nameExtension).toString()) : (iteration == -1 ? Path.of(outputDirPath.toString(), outputType.value() + "_RunId_" + runId + "_" + nameRootNoSpace + "_" + timePeriod.getDescription().replace(' ', '_') + nameExtension).toString() : Path.of(outputDirPath.toString(), outputType.value() + "_RunId_" + runId + "_" + nameRootNoSpace + "_" + timePeriod.getDescription().replace(' ', '_') + "_" + iteration + nameExtension).toString());
            return newFileName;
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error when generating output file name in FileOutputFormatter", (Throwable)e);
        }
    }

    protected String generateAbsoluteOutputFileName(String outputDirectory, String nameRoot, String nameExtension, TimePeriod timePeriod, OutputType outputType, long runId) throws PlanItException {
        return this.generateAbsoluteOutputFileName(outputDirectory, nameRoot, nameExtension, timePeriod, outputType, runId, -1);
    }
}

