/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.output.formatter;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import org.goplanit.output.adapter.OutputAdapter;
import org.goplanit.output.configuration.OutputConfiguration;
import org.goplanit.output.configuration.OutputTypeConfiguration;
import org.goplanit.output.enums.OutputType;
import org.goplanit.output.enums.OutputTypeEnum;
import org.goplanit.output.enums.SubOutputTypeEnum;
import org.goplanit.output.formatter.OutputFormatter;
import org.goplanit.output.property.OutputProperty;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.time.TimePeriod;
import org.goplanit.utils.unit.Unit;

public abstract class BaseOutputFormatter
implements OutputFormatter {
    private static final Logger LOGGER = Logger.getLogger(BaseOutputFormatter.class.getCanonicalName());
    private static final Unit DEFAULT_TIME_UNIT = Unit.HOUR;
    protected Map<OutputType, OutputProperty[]> outputKeyProperties;
    protected Map<OutputType, OutputProperty[]> outputValueProperties;
    protected Map<OutputType, Boolean> outputTypeValuesLocked;
    protected Map<OutputType, Boolean> outputTypeKeysLocked;
    protected long id;
    protected Unit outputTimeUnit;
    protected Set<OutputType> outputTypes;
    protected String initialCostsLocation;

    private void initializeKeyProperties(OutputTypeConfiguration outputTypeConfiguration) throws PlanItException {
        OutputProperty[] outputKeyPropertyArray = outputTypeConfiguration.getOutputKeyProperties();
        OutputType outputType = outputTypeConfiguration.getOutputType();
        OutputProperty[] outputKeyPropertiesArray = outputTypeConfiguration.validateAndFilterKeyProperties(outputKeyPropertyArray);
        PlanItException.throwIf((outputKeyPropertiesArray == null ? 1 : 0) != 0, (String)("Key properties invalid for OutputType " + outputType.value() + " not correctly defined"), (Object[])new Object[0]);
        this.outputKeyProperties.put(outputType, outputKeyPropertiesArray);
    }

    protected void lockOutputProperties(OutputType outputType) {
        this.outputTypeValuesLocked.put(outputType, true);
        this.outputTypeKeysLocked.put(outputType, true);
    }

    protected abstract void writeLinkResultsForCurrentTimePeriod(OutputConfiguration var1, OutputTypeConfiguration var2, OutputTypeEnum var3, OutputAdapter var4, Set<Mode> var5, TimePeriod var6, int var7) throws PlanItException;

    protected abstract void writeGeneralResultsForCurrentTimePeriod(OutputConfiguration var1, OutputTypeConfiguration var2, OutputTypeEnum var3, OutputAdapter var4, Set<Mode> var5, TimePeriod var6, int var7) throws PlanItException;

    protected abstract void writeOdResultsForCurrentTimePeriod(OutputConfiguration var1, OutputTypeConfiguration var2, OutputTypeEnum var3, OutputAdapter var4, Set<Mode> var5, TimePeriod var6, int var7) throws PlanItException;

    protected abstract void writeSimulationResultsForCurrentTimePeriod(OutputConfiguration var1, OutputTypeConfiguration var2, OutputTypeEnum var3, OutputAdapter var4, Set<Mode> var5, TimePeriod var6, int var7) throws PlanItException;

    protected abstract void writePathResultsForCurrentTimePeriod(OutputConfiguration var1, OutputTypeConfiguration var2, OutputTypeEnum var3, OutputAdapter var4, Set<Mode> var5, TimePeriod var6, int var7) throws PlanItException;

    public BaseOutputFormatter(IdGroupingToken groupId) {
        this.id = IdGenerator.generateId((IdGroupingToken)groupId, BaseOutputFormatter.class);
        this.outputKeyProperties = new HashMap<OutputType, OutputProperty[]>();
        this.outputValueProperties = new HashMap<OutputType, OutputProperty[]>();
        this.outputTimeUnit = DEFAULT_TIME_UNIT;
        this.outputTypeValuesLocked = new HashMap<OutputType, Boolean>();
        this.outputTypeKeysLocked = new HashMap<OutputType, Boolean>();
        for (OutputType outputType : OutputType.values()) {
            this.outputTypeValuesLocked.put(outputType, false);
            this.outputTypeKeysLocked.put(outputType, false);
        }
    }

    @Override
    public void persist(TimePeriod timePeriod, Set<Mode> modes, OutputConfiguration outputConfiguration, OutputTypeConfiguration outputTypeConfiguration, OutputAdapter outputAdapter) throws PlanItException {
        OutputType outputType = outputTypeConfiguration.getOutputType();
        OutputProperty[] outputValuePropertyArray = outputTypeConfiguration.getOutputValueProperties();
        if (!this.outputTypeValuesLocked.get(outputType).booleanValue()) {
            this.outputValueProperties.put(outputType, outputValuePropertyArray);
        } else {
            OutputProperty[] existingOutputValuePropertyArray = this.outputValueProperties.get(outputType);
            PlanItException.throwIf((outputValuePropertyArray.length != existingOutputValuePropertyArray.length ? 1 : 0) != 0, (String)"An attempt was made to change the output value properties after they had been locked", (Object[])new Object[0]);
            for (int i = 0; i < outputValuePropertyArray.length; ++i) {
                PlanItException.throwIf((!existingOutputValuePropertyArray[i].equals(outputValuePropertyArray[i]) ? 1 : 0) != 0, (String)"An attempt was made to change the output value properties after they had been locked", (Object[])new Object[0]);
            }
        }
        if (!this.outputTypeKeysLocked.get(outputType).booleanValue()) {
            this.initializeKeyProperties(outputTypeConfiguration);
        }
        HashMap<OutputTypeEnum, Integer> outputTypeIterationInformation = new HashMap<OutputTypeEnum, Integer>();
        if (outputTypeConfiguration.hasActiveSubOutputTypes()) {
            Set<SubOutputTypeEnum> subOutputTypes = outputTypeConfiguration.getActiveSubOutputTypes();
            for (SubOutputTypeEnum subOutputTypeEnum : subOutputTypes) {
                Optional<Integer> iterationIndex = outputAdapter.getOutputTypeAdapter(outputType).getIterationIndexForSubOutputType(subOutputTypeEnum);
                if (iterationIndex.isEmpty()) {
                    throw new PlanItException("iteration index could not be retrieved when persisting");
                }
                outputTypeIterationInformation.put(subOutputTypeEnum, iterationIndex.get());
            }
        } else {
            Optional<Integer> iterationIndex = outputAdapter.getOutputTypeAdapter(outputType).getIterationIndexForSubOutputType(null);
            if (iterationIndex.isEmpty()) {
                throw new PlanItException("iteration index could not be retrieved when persisting");
            }
            outputTypeIterationInformation.put(outputType, iterationIndex.get());
        }
        for (Map.Entry entry : outputTypeIterationInformation.entrySet()) {
            OutputTypeEnum currentOutputTypeEnum = (OutputTypeEnum)entry.getKey();
            int iterationIndex = (Integer)entry.getValue();
            switch (outputType) {
                case GENERAL: {
                    this.writeGeneralResultsForCurrentTimePeriod(outputConfiguration, outputTypeConfiguration, currentOutputTypeEnum, outputAdapter, modes, timePeriod, iterationIndex);
                    break;
                }
                case LINK: {
                    this.writeLinkResultsForCurrentTimePeriod(outputConfiguration, outputTypeConfiguration, currentOutputTypeEnum, outputAdapter, modes, timePeriod, iterationIndex);
                    break;
                }
                case OD: {
                    this.writeOdResultsForCurrentTimePeriod(outputConfiguration, outputTypeConfiguration, currentOutputTypeEnum, outputAdapter, modes, timePeriod, iterationIndex);
                    break;
                }
                case SIMULATION: {
                    this.writeSimulationResultsForCurrentTimePeriod(outputConfiguration, outputTypeConfiguration, currentOutputTypeEnum, outputAdapter, modes, timePeriod, iterationIndex);
                    break;
                }
                case PATH: {
                    this.writePathResultsForCurrentTimePeriod(outputConfiguration, outputTypeConfiguration, currentOutputTypeEnum, outputAdapter, modes, timePeriod, iterationIndex);
                }
            }
            this.lockOutputProperties(outputType);
        }
    }

    @Override
    public long getId() {
        return this.id;
    }
}

