/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.output.configuration;

import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.logging.Logger;
import org.goplanit.output.enums.OutputType;
import org.goplanit.output.enums.SubOutputTypeEnum;
import org.goplanit.output.property.OutputProperty;
import org.goplanit.output.property.OutputPropertyPriority;
import org.goplanit.output.property.OutputPropertyType;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.unit.Unit;

public abstract class OutputTypeConfiguration {
    protected static final Logger LOGGER = Logger.getLogger(OutputTypeConfiguration.class.getCanonicalName());
    protected OutputType outputType;
    protected Set<SubOutputTypeEnum> activeSubOutputTypes;
    protected SortedSet<OutputProperty> outputProperties;

    private OutputProperty[] getOutputPropertyArray(Function<OutputProperty, Boolean> test) {
        OutputProperty[] outputPropertyArray = (OutputProperty[])this.outputProperties.stream().filter(baseOutputProperty -> (Boolean)test.apply((OutputProperty)baseOutputProperty)).toArray(OutputProperty[]::new);
        return outputPropertyArray;
    }

    protected void activateSubOutputType(SubOutputTypeEnum subOutputTypeEnum) {
        this.activeSubOutputTypes.add(subOutputTypeEnum);
    }

    protected void deactivateSubOutputType(SubOutputTypeEnum subOutputTypeEnum) {
        this.activeSubOutputTypes.remove(subOutputTypeEnum);
    }

    public abstract boolean isOutputPropertyValid(OutputProperty var1);

    public abstract OutputProperty[] validateAndFilterKeyProperties(OutputProperty[] var1);

    public OutputTypeConfiguration(OutputType outputType) throws PlanItException {
        this.outputType = outputType;
        this.outputProperties = new TreeSet<OutputProperty>();
        this.activeSubOutputTypes = new TreeSet<SubOutputTypeEnum>();
    }

    public OutputType getOutputType() {
        return this.outputType;
    }

    public boolean hasActiveSubOutputTypes() {
        return !this.activeSubOutputTypes.isEmpty();
    }

    public void addProperty(OutputPropertyType outputProperty) throws PlanItException {
        OutputProperty baseOutputProperty = OutputProperty.of(outputProperty);
        if (this.isOutputPropertyValid(baseOutputProperty)) {
            this.outputProperties.add(baseOutputProperty);
        }
    }

    public boolean removeProperty(String propertyClassName) throws PlanItException {
        return this.outputProperties.remove(OutputProperty.of(propertyClassName));
    }

    public boolean removeProperty(OutputPropertyType outputProperty) throws PlanItException {
        OutputProperty baseOutputProperty = OutputProperty.of(outputProperty);
        if (this.outputProperties.contains(baseOutputProperty)) {
            return this.outputProperties.remove(baseOutputProperty);
        }
        return true;
    }

    public void removeAllProperties() {
        this.outputProperties.clear();
    }

    public OutputProperty getOutputProperty(OutputPropertyType outputPropertyType) {
        return this.outputProperties.stream().dropWhile(prop -> !prop.getOutputPropertyType().equals((Object)outputPropertyType)).findFirst().orElseGet(null);
    }

    public OutputProperty[] getOutputKeyProperties() {
        return this.getOutputPropertyArray(baseOutputProperty -> baseOutputProperty.getColumnPriority().equals((Object)OutputPropertyPriority.ID_PRIORITY));
    }

    public OutputProperty[] getOutputValueProperties() {
        return this.getOutputPropertyArray(baseOutputProperty -> !baseOutputProperty.getColumnPriority().equals((Object)OutputPropertyPriority.ID_PRIORITY));
    }

    public SortedSet<OutputProperty> getOutputProperties() {
        return this.outputProperties;
    }

    public Set<SubOutputTypeEnum> getActiveSubOutputTypes() {
        return this.activeSubOutputTypes;
    }

    public void overrideOutputPropertyUnits(OutputPropertyType outputPropertyType, Unit overrideUnits) {
        OutputProperty outputProperty = this.getOutputProperty(outputPropertyType);
        if (outputProperty != null) {
            if (!outputProperty.supportsUnitOverride()) {
                LOGGER.warning(String.format("IGNORE: Output property %s does not (yet) support overriding its units", outputProperty.getName()));
                return;
            }
            outputProperty.setUnitOverride(overrideUnits);
        }
    }
}

