/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.output.adapter;

import java.util.logging.Logger;
import org.goplanit.assignment.TrafficAssignment;
import org.goplanit.output.adapter.OutputTypeAdapterImpl;
import org.goplanit.output.adapter.UntypedLinkOutputTypeAdapter;
import org.goplanit.output.enums.OutputType;
import org.goplanit.utils.graph.GraphEntities;
import org.goplanit.utils.network.layer.NetworkLayer;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.network.layer.physical.PhysicalLayer;
import org.goplanit.utils.network.layers.TopologicalLayers;

public abstract class PhysicalLinkOutputTypeAdapterImpl
extends OutputTypeAdapterImpl
implements UntypedLinkOutputTypeAdapter<LinkSegment> {
    private static final Logger LOGGER = Logger.getLogger(PhysicalLinkOutputTypeAdapterImpl.class.getCanonicalName());

    public PhysicalLinkOutputTypeAdapterImpl(OutputType outputType, TrafficAssignment trafficAssignment) {
        super(outputType, trafficAssignment);
    }

    @Override
    public GraphEntities<LinkSegment> getPhysicalLinkSegments(long infrastructureLayerId) {
        NetworkLayer networkLayer = (NetworkLayer)((TopologicalLayers)this.getAssignment().getTransportNetwork().getInfrastructureNetwork().getTransportLayers()).get(infrastructureLayerId);
        if (networkLayer instanceof PhysicalLayer) {
            return ((PhysicalLayer)networkLayer).getLinkSegments();
        }
        LOGGER.warning(String.format("Cannot collect physical link segments from infrastructure layer %s, as it is not a physical network layer", networkLayer.getXmlId()));
        return null;
    }
}

