/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.output.adapter;

import java.util.Optional;
import org.goplanit.od.path.OdPathMatrix;
import org.goplanit.output.adapter.OutputTypeAdapter;
import org.goplanit.output.enums.PathOutputIdentificationType;
import org.goplanit.output.property.OutputProperty;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.ExternalIdAble;
import org.goplanit.utils.id.IdAble;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.od.OdDataIterator;
import org.goplanit.utils.path.ManagedDirectedPath;
import org.goplanit.utils.path.PathUtils;
import org.goplanit.utils.time.TimePeriod;

public interface PathOutputTypeAdapter
extends OutputTypeAdapter {
    public static Optional<String> getDestinationZoneExternalId(OdDataIterator<?> odPathIterator) throws PlanItException {
        return Optional.of(odPathIterator.getCurrentDestination().getExternalId());
    }

    public static Optional<String> getDestinationZoneXmlId(OdDataIterator<?> odPathIterator) throws PlanItException {
        return Optional.of(odPathIterator.getCurrentDestination().getXmlId());
    }

    public static Optional<Long> getDestinationZoneId(OdDataIterator<?> odPathIterator) throws PlanItException {
        return Optional.of(odPathIterator.getCurrentDestination().getId());
    }

    public static Optional<String> getOriginZoneExternalId(OdDataIterator<?> odPathIterator) throws PlanItException {
        return Optional.of(odPathIterator.getCurrentOrigin().getExternalId());
    }

    public static Optional<String> getOriginZoneXmlId(OdDataIterator<?> odPathIterator) throws PlanItException {
        return Optional.of(odPathIterator.getCurrentOrigin().getXmlId());
    }

    public static Optional<Long> getOriginZoneId(OdDataIterator<?> odPathIterator) throws PlanItException {
        return Optional.of(odPathIterator.getCurrentOrigin().getId());
    }

    public static Optional<String> getPathAsString(OdDataIterator<? extends ManagedDirectedPath> odPathIterator, PathOutputIdentificationType pathOutputType) {
        ManagedDirectedPath path = (ManagedDirectedPath)odPathIterator.getCurrentValue();
        if (path != null) {
            switch (pathOutputType) {
                case LINK_SEGMENT_EXTERNAL_ID: {
                    return Optional.of(PathUtils.getEdgeSegmentPathString((ManagedDirectedPath)path, ExternalIdAble::getExternalId));
                }
                case LINK_SEGMENT_XML_ID: {
                    return Optional.of(PathUtils.getEdgeSegmentPathString((ManagedDirectedPath)path, ExternalIdAble::getXmlId));
                }
                case LINK_SEGMENT_ID: {
                    return Optional.of(PathUtils.getEdgeSegmentPathString((ManagedDirectedPath)path, IdAble::getId));
                }
                case NODE_EXTERNAL_ID: {
                    return Optional.of(PathUtils.getNodePathString((ManagedDirectedPath)path, ExternalIdAble::getExternalId));
                }
                case NODE_XML_ID: {
                    return Optional.of(PathUtils.getNodePathString((ManagedDirectedPath)path, ExternalIdAble::getXmlId));
                }
                case NODE_ID: {
                    return Optional.of(PathUtils.getNodePathString((ManagedDirectedPath)path, IdAble::getId));
                }
            }
            return Optional.of("");
        }
        return Optional.of("");
    }

    public static Optional<Long> getPathId(OdDataIterator<? extends ManagedDirectedPath> odPathIterator) {
        ManagedDirectedPath path = (ManagedDirectedPath)odPathIterator.getCurrentValue();
        if (path == null) {
            return Optional.of(-1L);
        }
        return Optional.of(((ManagedDirectedPath)odPathIterator.getCurrentValue()).getId());
    }

    public Optional<OdPathMatrix> getOdPathMatrix(Mode var1);

    public Optional<?> getPathOutputPropertyValue(OutputProperty var1, OdDataIterator<? extends ManagedDirectedPath> var2, Mode var3, TimePeriod var4, PathOutputIdentificationType var5);
}

