/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.output.adapter;

import java.util.Optional;
import org.goplanit.assignment.TrafficAssignment;
import org.goplanit.output.adapter.OutputTypeAdapter;
import org.goplanit.output.enums.OutputType;
import org.goplanit.output.enums.SubOutputTypeEnum;
import org.goplanit.output.property.IterationIndexOutputProperty;
import org.goplanit.output.property.ModeExternalIdOutputProperty;
import org.goplanit.output.property.ModeIdOutputProperty;
import org.goplanit.output.property.ModeXmlIdOutputProperty;
import org.goplanit.output.property.OutputProperty;
import org.goplanit.output.property.RunIdOutputProperty;
import org.goplanit.output.property.TimePeriodExternalIdOutputProperty;
import org.goplanit.output.property.TimePeriodIdOutputProperty;
import org.goplanit.output.property.TimePeriodXmlIdOutputProperty;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.time.TimePeriod;

public abstract class OutputTypeAdapterImpl
implements OutputTypeAdapter {
    private TrafficAssignment trafficAssignment;
    protected OutputType outputType;

    protected TrafficAssignment getAssignment() {
        return this.trafficAssignment;
    }

    protected static Optional<?> createConvertedUnitsValue(OutputProperty outputProperty, Optional<?> unconvertedValue) throws PlanItException {
        if (unconvertedValue.isPresent()) {
            return Optional.of(outputProperty.getDefaultUnit().convertTo(outputProperty.getOverrideUnit(), ((Double)unconvertedValue.get()).doubleValue()));
        }
        return unconvertedValue;
    }

    protected Optional<?> getOutputTypeIndependentPropertyValue(OutputProperty outputProperty, Mode mode, TimePeriod timePeriod) {
        try {
            switch (outputProperty.getOutputPropertyType()) {
                case MODE_EXTERNAL_ID: {
                    return ModeExternalIdOutputProperty.getModeExternalId(mode);
                }
                case MODE_XML_ID: {
                    return ModeXmlIdOutputProperty.getModeXmlId(mode);
                }
                case MODE_ID: {
                    return ModeIdOutputProperty.getModeId(mode);
                }
                case RUN_ID: {
                    return RunIdOutputProperty.getRunId(this.trafficAssignment);
                }
                case TIME_PERIOD_EXTERNAL_ID: {
                    return TimePeriodExternalIdOutputProperty.getTimePeriodExternalId(timePeriod);
                }
                case TIME_PERIOD_XML_ID: {
                    return TimePeriodXmlIdOutputProperty.getTimePeriodXmlId(timePeriod);
                }
                case TIME_PERIOD_ID: {
                    return TimePeriodIdOutputProperty.getTimePeriodId(timePeriod);
                }
                case ITERATION_INDEX: {
                    return IterationIndexOutputProperty.getIterationIndex(this.trafficAssignment);
                }
            }
            return Optional.empty();
        }
        catch (PlanItException e) {
            return Optional.of(e.getMessage());
        }
    }

    public OutputTypeAdapterImpl(OutputType outputType, TrafficAssignment trafficAssignment) {
        this.outputType = outputType;
        this.trafficAssignment = trafficAssignment;
    }

    @Override
    public OutputType getOutputType() {
        return this.outputType;
    }

    @Override
    public Optional<Integer> getIterationIndexForSubOutputType(SubOutputTypeEnum outputTypeEnum) throws PlanItException {
        return Optional.of(this.trafficAssignment.getIterationIndex());
    }
}

