/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.output.adapter;

import java.util.HashMap;
import java.util.Map;
import org.goplanit.assignment.TrafficAssignment;
import org.goplanit.output.adapter.OutputTypeAdapter;
import org.goplanit.output.enums.OutputType;

public class OutputAdapter {
    private TrafficAssignment trafficAssignment;
    private Map<OutputType, OutputTypeAdapter> outputTypeAdapters;

    protected String getClassName(Object object) {
        String name = object.getClass().getCanonicalName();
        String[] words = name.split("\\.");
        return words[words.length - 1];
    }

    public OutputAdapter(TrafficAssignment trafficAssignment) {
        this.trafficAssignment = trafficAssignment;
        this.outputTypeAdapters = new HashMap<OutputType, OutputTypeAdapter>();
    }

    public long getRunId() {
        return this.trafficAssignment.getId();
    }

    public String getAssignmentClassName() {
        return this.getClassName(this.trafficAssignment);
    }

    public String getPhysicalCostClassName() {
        return this.getClassName(this.trafficAssignment.getPhysicalCost());
    }

    public String getVirtualCostClassName() {
        return this.getClassName(this.trafficAssignment.getVirtualCost());
    }

    public String getSmoothingClassName() {
        return this.getClassName(this.trafficAssignment.getSmoothing());
    }

    public String getGapFunctionClassName() {
        return this.getClassName(this.trafficAssignment.getGapFunction());
    }

    public String getStopCriterionClassName() {
        return this.getClassName(this.trafficAssignment.getGapFunction().getStopCriterion());
    }

    public void registerOutputTypeAdapter(OutputType outputType, OutputTypeAdapter outputTypeAdapter) {
        this.outputTypeAdapters.put(outputType, outputTypeAdapter);
    }

    public void deregisterOutputTypeAdapter(OutputType outputType) {
        this.outputTypeAdapters.remove(outputType);
    }

    public OutputTypeAdapter getOutputTypeAdapter(OutputType outputType) {
        return this.outputTypeAdapters.get(outputType);
    }

    public void reset() {
        this.outputTypeAdapters.clear();
    }
}

