/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.output.adapter;

import java.util.Optional;
import java.util.logging.Logger;
import org.goplanit.assignment.TrafficAssignment;
import org.goplanit.output.adapter.OdOutputTypeAdapter;
import org.goplanit.output.adapter.OutputTypeAdapterImpl;
import org.goplanit.output.enums.OdSkimSubOutputType;
import org.goplanit.output.enums.OutputType;
import org.goplanit.output.enums.SubOutputTypeEnum;
import org.goplanit.output.property.OutputProperty;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.od.OdDataIterator;
import org.goplanit.utils.time.TimePeriod;

public abstract class OdOutputTypeAdapterImpl
extends OutputTypeAdapterImpl
implements OdOutputTypeAdapter {
    private static final Logger LOGGER = Logger.getLogger(OdOutputTypeAdapterImpl.class.getCanonicalName());

    public OdOutputTypeAdapterImpl(OutputType outputType, TrafficAssignment trafficAssignment) {
        super(outputType, trafficAssignment);
    }

    @Override
    public Optional<?> getOdOutputPropertyValue(OutputProperty outputProperty, OdDataIterator<?> odIterator, Mode mode, TimePeriod timePeriod) {
        Optional<Object> value = Optional.empty();
        try {
            value = this.getOutputTypeIndependentPropertyValue(outputProperty, mode, timePeriod);
            if (value.isPresent()) {
                return value;
            }
            switch (outputProperty.getOutputPropertyType()) {
                case DESTINATION_ZONE_EXTERNAL_ID: {
                    value = OdOutputTypeAdapter.getDestinationZoneExternalId(odIterator);
                    break;
                }
                case DESTINATION_ZONE_XML_ID: {
                    value = OdOutputTypeAdapter.getDestinationZoneXmlId(odIterator);
                    break;
                }
                case DESTINATION_ZONE_ID: {
                    value = OdOutputTypeAdapter.getDestinationZoneId(odIterator);
                    break;
                }
                case OD_COST: {
                    value = OdOutputTypeAdapter.getOdValue(odIterator);
                    break;
                }
                case ORIGIN_ZONE_EXTERNAL_ID: {
                    value = OdOutputTypeAdapter.getOriginZoneExternalId(odIterator);
                    break;
                }
                case ORIGIN_ZONE_XML_ID: {
                    value = OdOutputTypeAdapter.getOriginZoneXmlId(odIterator);
                    break;
                }
                case ORIGIN_ZONE_ID: {
                    value = OdOutputTypeAdapter.getOriginZoneId(odIterator);
                    break;
                }
                default: {
                    throw new PlanItException("Tried to find link property of %s which is not applicable for OD matrix", new Object[]{outputProperty.getName()});
                }
            }
            if (outputProperty.supportsUnitOverride() && outputProperty.isUnitOverride()) {
                value = OdOutputTypeAdapterImpl.createConvertedUnitsValue(outputProperty, value);
            }
        }
        catch (PlanItException e) {
            value = Optional.of(e.getMessage());
        }
        return value;
    }

    @Override
    public Optional<Integer> getIterationIndexForSubOutputType(SubOutputTypeEnum outputTypeEnum) throws PlanItException {
        PlanItException.throwIf((!(outputTypeEnum instanceof OdSkimSubOutputType) ? 1 : 0) != 0, (String)"Incorrect outputType enum found when collecting iteration index", (Object[])new Object[0]);
        int iterationIndex = this.getAssignment().getIterationIndex();
        switch ((OdSkimSubOutputType)outputTypeEnum) {
            case COST: {
                return Optional.of(iterationIndex - 1);
            }
            case NONE: {
                return Optional.of(iterationIndex);
            }
        }
        throw new PlanItException("Unknown ODSkimOutputType enum encountered when collecting iteration index");
    }
}

