/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.output.adapter;

import java.util.Optional;
import org.goplanit.output.adapter.UntypedLinkOutputTypeAdapter;
import org.goplanit.output.property.OutputProperty;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.time.TimePeriod;

public interface MacroscopicLinkOutputTypeAdapter
extends UntypedLinkOutputTypeAdapter<MacroscopicLinkSegment> {
    default public Optional<Double> getCapacityPerLanePcuHour(MacroscopicLinkSegment linkSegment) throws PlanItException {
        return Optional.of(linkSegment.getLinkSegmentType().getExplicitCapacityPerLaneOrDefault());
    }

    default public Optional<String> getLinkSegmentTypeName(MacroscopicLinkSegment linkSegment) throws PlanItException {
        return Optional.of(linkSegment.getLinkSegmentType().getName());
    }

    default public Optional<Long> getLinkSegmentTypeId(MacroscopicLinkSegment linkSegment) throws PlanItException {
        return Optional.of(linkSegment.getLinkSegmentType().getId());
    }

    default public Optional<String> getLinkSegmentTypeXmlId(MacroscopicLinkSegment linkSegment) throws PlanItException {
        return Optional.of(linkSegment.getLinkSegmentType().getXmlId());
    }

    default public Optional<Double> getMaximumDensity(MacroscopicLinkSegment linkSegment) throws PlanItException {
        return Optional.of(linkSegment.getLinkSegmentType().getExplicitMaximumDensityPerLaneOrDefault());
    }

    @Override
    default public Optional<String> getDownstreamNodeExternalId(MacroscopicLinkSegment linkSegment) throws PlanItException {
        return Optional.of(linkSegment.getDownstreamVertex().getExternalId());
    }

    default public Optional<Double> getMaximumSpeed(MacroscopicLinkSegment linkSegment, Mode mode) throws PlanItException {
        return Optional.of(linkSegment.getModelledSpeedLimitKmH(mode));
    }

    public Optional<Long> getInfrastructureLayerIdForMode(Mode var1);

    public Optional<Boolean> isFlowPositive(MacroscopicLinkSegment var1, Mode var2);

    public Optional<?> getLinkSegmentOutputPropertyValue(OutputProperty var1, MacroscopicLinkSegment var2, Mode var3, TimePeriod var4);
}

