/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.output;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.goplanit.assignment.TrafficAssignment;
import org.goplanit.output.adapter.OutputAdapter;
import org.goplanit.output.adapter.OutputTypeAdapter;
import org.goplanit.output.configuration.OutputConfiguration;
import org.goplanit.output.configuration.OutputTypeConfiguration;
import org.goplanit.output.enums.OutputType;
import org.goplanit.output.formatter.OutputFormatter;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.time.TimePeriod;

public class OutputManager {
    private static final Logger LOGGER = Logger.getLogger(OutputManager.class.getCanonicalName());
    private OutputConfiguration outputConfiguration;
    private List<OutputFormatter> outputFormatters = new ArrayList<OutputFormatter>();
    private OutputAdapter outputAdapter;

    public OutputManager() {
        this.outputConfiguration = new OutputConfiguration();
    }

    public void initialiseBeforeSimulation(long runId) throws PlanItException {
        for (OutputFormatter outputFormatter : this.outputFormatters) {
            outputFormatter.initialiseBeforeSimulation(this.outputConfiguration, runId);
        }
    }

    public void finaliseAfterSimulation() throws PlanItException {
        for (OutputFormatter outputFormatter : this.outputFormatters) {
            outputFormatter.finaliseAfterSimulation(this.outputConfiguration, this.outputAdapter);
        }
    }

    public void persistOutputData(TimePeriod timePeriod, Set<Mode> modes, boolean converged) throws PlanItException {
        for (OutputType outputType : this.outputConfiguration.getActivatedOutputTypes()) {
            OutputTypeConfiguration outputTypeConfiguration = this.outputConfiguration.getOutputTypeConfiguration(outputType);
            if (!converged && this.outputConfiguration.isPersistOnlyFinalIteration()) continue;
            for (OutputFormatter outputFormatter : this.outputFormatters) {
                if (!converged && !outputFormatter.canHandleMultipleIterations()) continue;
                outputFormatter.persist(timePeriod, modes, this.outputConfiguration, outputTypeConfiguration, this.outputAdapter);
            }
        }
    }

    public boolean isAnyOutputPersisted(TimePeriod timePeriod, Set<Mode> modes, boolean converged) {
        if (converged || !this.outputConfiguration.isPersistOnlyFinalIteration()) {
            for (OutputFormatter outputFormatter : this.outputFormatters) {
                if (!converged && !outputFormatter.canHandleMultipleIterations()) continue;
                return true;
            }
        }
        return false;
    }

    public OutputTypeConfiguration createAndRegisterOutputTypeConfiguration(OutputType outputType) throws PlanItException {
        return this.outputConfiguration.createAndRegisterOutputTypeConfiguration(outputType);
    }

    public void deregisterOutputTypeConfiguration(OutputType outputType) {
        this.outputConfiguration.deregisterOutputTypeConfiguration(outputType);
    }

    public void registerOutputTypeAdapter(OutputTypeAdapter outputTypeAdapter) {
        if (this.outputAdapter == null) {
            LOGGER.warning(String.format("Output adapter not available to register type on, ignored regeistration of %s instance", outputTypeAdapter.getClass().getCanonicalName()));
            return;
        }
        if (outputTypeAdapter == null) {
            LOGGER.warning("Output type adapter that is registered is null, ignored");
            return;
        }
        this.outputAdapter.registerOutputTypeAdapter(outputTypeAdapter.getOutputType(), outputTypeAdapter);
    }

    public void deregisterOutputTypeAdapter(OutputType outputType) {
        if (this.outputAdapter != null) {
            this.outputAdapter.deregisterOutputTypeAdapter(outputType);
        }
    }

    public OutputConfiguration getOutputConfiguration() {
        return this.outputConfiguration;
    }

    public void registerOutputFormatter(OutputFormatter outputFormatter) {
        this.outputFormatters.add(outputFormatter);
    }

    public void unregisterOutputFormatter(OutputFormatter outputFormatter) {
        this.outputFormatters.remove(outputFormatter);
    }

    public List<OutputFormatter> getOutputFormatters() {
        return this.outputFormatters;
    }

    public boolean isOutputTypeActive(OutputType outputType) {
        return this.outputConfiguration.isOutputTypeActive(outputType);
    }

    public OutputTypeConfiguration getOutputTypeConfiguration(OutputType outputType) {
        return this.outputConfiguration.getOutputTypeConfiguration(outputType);
    }

    public Collection<OutputTypeConfiguration> getRegisteredOutputTypeConfigurations() {
        return this.outputConfiguration.getActivatedOutputTypeConfigurations();
    }

    public Set<OutputType> getRegisteredOutputTypes() {
        return this.outputConfiguration.getActivatedOutputTypes();
    }

    public void initialiseOutputAdapters(TrafficAssignment trafficAssignment) {
        this.outputAdapter = new OutputAdapter(trafficAssignment);
        for (OutputTypeConfiguration otc : this.getRegisteredOutputTypeConfigurations()) {
            OutputTypeAdapter outputTypeAdapter = trafficAssignment.createOutputTypeAdapter(otc.getOutputType());
            this.registerOutputTypeAdapter(outputTypeAdapter);
        }
    }

    public void reset() {
        this.outputAdapter.reset();
        this.outputFormatters.clear();
    }
}

