/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.virtual;

import java.util.function.BiConsumer;
import java.util.logging.Logger;
import org.goplanit.network.Network;
import org.goplanit.network.virtual.CentroidVerticesImpl;
import org.goplanit.network.virtual.ConjugateVirtualNetworkImpl;
import org.goplanit.network.virtual.ConnectoidEdgesImpl;
import org.goplanit.network.virtual.ConnectoidSegmentsImpl;
import org.goplanit.utils.graph.EdgeUtils;
import org.goplanit.utils.graph.GraphEntityDeepCopyMapper;
import org.goplanit.utils.graph.VertexUtils;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegmentUtils;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.virtual.CentroidVertex;
import org.goplanit.utils.network.virtual.CentroidVertices;
import org.goplanit.utils.network.virtual.ConnectoidEdge;
import org.goplanit.utils.network.virtual.ConnectoidEdges;
import org.goplanit.utils.network.virtual.ConnectoidSegment;
import org.goplanit.utils.network.virtual.ConnectoidSegments;
import org.goplanit.utils.network.virtual.VirtualNetwork;

public class VirtualNetworkImpl
extends Network
implements VirtualNetwork {
    private static final long serialVersionUID = -4088201905917614130L;
    private static final Logger LOGGER = Logger.getLogger(VirtualNetworkImpl.class.getCanonicalName());
    protected final ConnectoidEdgesImpl connectoidEdges;
    protected final ConnectoidSegmentsImpl connectoidSegments;
    protected final CentroidVerticesImpl centroidVertices;

    public VirtualNetworkImpl(IdGroupingToken tokenId) {
        super(tokenId);
        this.connectoidSegments = new ConnectoidSegmentsImpl(this.getIdGroupingToken());
        this.connectoidEdges = new ConnectoidEdgesImpl(this.getIdGroupingToken());
        this.centroidVertices = new CentroidVerticesImpl(this.getIdGroupingToken());
    }

    protected VirtualNetworkImpl(VirtualNetworkImpl other, boolean deepCopy, GraphEntityDeepCopyMapper<ConnectoidEdge> connectoidEdgeMapper, GraphEntityDeepCopyMapper<ConnectoidSegment> connectoidSegmentMapper, GraphEntityDeepCopyMapper<CentroidVertex> centroidVertexMapper) {
        super(other, deepCopy);
        if (deepCopy) {
            this.connectoidSegments = other.connectoidSegments.deepCloneWithMapping((BiConsumer)connectoidSegmentMapper);
            this.connectoidEdges = other.connectoidEdges.deepCloneWithMapping((BiConsumer)connectoidEdgeMapper);
            this.centroidVertices = other.centroidVertices.deepCloneWithMapping((BiConsumer)centroidVertexMapper);
            VertexUtils.updateVertexEdges((Iterable)((Object)this.centroidVertices), edge -> (ConnectoidEdge)connectoidEdgeMapper.getMapping(edge), (boolean)true);
            EdgeUtils.updateEdgeVertices((Iterable)((Object)this.connectoidEdges), vertex -> {
                if (!(vertex instanceof CentroidVertex)) {
                    return null;
                }
                return (DirectedVertex)centroidVertexMapper.getMapping((Object)((CentroidVertex)vertex));
            }, (boolean)false);
            EdgeSegmentUtils.updateEdgeSegmentParentEdges((Iterable)((Object)this.connectoidSegments), originalEdge -> (ConnectoidEdge)connectoidEdgeMapper.getMapping(originalEdge), (boolean)true);
        } else {
            this.connectoidSegments = other.connectoidSegments.shallowClone();
            this.connectoidEdges = other.connectoidEdges.shallowClone();
            this.centroidVertices = other.centroidVertices.shallowClone();
        }
    }

    public ConnectoidSegments getConnectoidSegments() {
        return this.connectoidSegments;
    }

    public ConnectoidEdges getConnectoidEdges() {
        return this.connectoidEdges;
    }

    public CentroidVertices getCentroidVertices() {
        return this.centroidVertices;
    }

    public void clear() {
        this.connectoidEdges.clear();
        this.connectoidSegments.clear();
        this.centroidVertices.clear();
    }

    @Override
    public void reset() {
        this.connectoidEdges.reset();
        this.connectoidSegments.reset();
        this.centroidVertices.reset();
    }

    @Override
    public void logInfo(String prefix) {
        LOGGER.info(String.format("%s#connectoid edges: %d", prefix, this.getConnectoidEdges().size()));
        LOGGER.info(String.format("%s#connectoid segments: %d", prefix, this.getConnectoidSegments().size()));
        LOGGER.info(String.format("%s#centroid vertices: %d", prefix, this.getCentroidVertices().size()));
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }

    public ConjugateVirtualNetworkImpl createConjugate(IdGroupingToken idToken) {
        ConjugateVirtualNetworkImpl conjugateVirtualNetwork = new ConjugateVirtualNetworkImpl(idToken, this);
        conjugateVirtualNetwork.update();
        return conjugateVirtualNetwork;
    }

    @Override
    public VirtualNetworkImpl shallowClone() {
        return new VirtualNetworkImpl(this, false, null, null, null);
    }

    @Override
    public VirtualNetworkImpl deepClone() {
        return this.deepCloneWithMapping(new GraphEntityDeepCopyMapper(), new GraphEntityDeepCopyMapper(), new GraphEntityDeepCopyMapper());
    }

    public VirtualNetworkImpl deepCloneWithMapping(GraphEntityDeepCopyMapper<ConnectoidEdge> connectoidEdgeMapper, GraphEntityDeepCopyMapper<ConnectoidSegment> connectoidSegmentMapper, GraphEntityDeepCopyMapper<CentroidVertex> centroidVertexMapper) {
        return new VirtualNetworkImpl(this, true, connectoidEdgeMapper, connectoidSegmentMapper, centroidVertexMapper);
    }
}

