/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.virtual;

import org.goplanit.graph.directed.EdgeSegmentImpl;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.virtual.ConnectoidEdge;
import org.goplanit.utils.network.virtual.ConnectoidSegment;

public class ConnectoidSegmentImpl
extends EdgeSegmentImpl<ConnectoidEdge>
implements ConnectoidSegment {
    private static final long serialVersionUID = 6462304338451088764L;
    private long connectoidSegmentId;

    protected static long generateConnectoidSegmentId(IdGroupingToken groupId) {
        return IdGenerator.generateId((IdGroupingToken)groupId, (Class)ConnectoidSegment.CONNECTOID_SEGMENT_ID_CLASS);
    }

    protected void setConnectoidSegmentId(long connectoidSegmentId) {
        this.connectoidSegmentId = connectoidSegmentId;
    }

    protected long recreateConnectoidSegmentId(IdGroupingToken tokenId) {
        long newConnectoidSegmentId = ConnectoidSegmentImpl.generateConnectoidSegmentId(tokenId);
        this.setConnectoidSegmentId(newConnectoidSegmentId);
        return newConnectoidSegmentId;
    }

    protected ConnectoidSegmentImpl(IdGroupingToken groupId, ConnectoidEdge parentEdge, boolean directionAb) {
        super(groupId, parentEdge, directionAb);
        this.setConnectoidSegmentId(ConnectoidSegmentImpl.generateConnectoidSegmentId(groupId));
    }

    protected ConnectoidSegmentImpl(ConnectoidSegmentImpl other, boolean deepCopy) {
        super(other, deepCopy);
        this.setConnectoidSegmentId(other.getConnectoidSegmentId());
    }

    @Override
    public long recreateManagedIds(IdGroupingToken tokenId) {
        this.recreateConnectoidSegmentId(tokenId);
        return super.recreateManagedIds(tokenId);
    }

    public long getConnectoidSegmentId() {
        return this.connectoidSegmentId;
    }

    @Override
    public ConnectoidSegmentImpl shallowClone() {
        return new ConnectoidSegmentImpl(this, false);
    }

    @Override
    public ConnectoidSegmentImpl deepClone() {
        return new ConnectoidSegmentImpl(this, true);
    }
}

