/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.virtual;

import java.util.logging.Logger;
import org.goplanit.graph.directed.DirectedEdgeImpl;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.virtual.CentroidVertex;
import org.goplanit.utils.network.virtual.ConnectoidEdge;
import org.goplanit.utils.network.virtual.ConnectoidSegment;
import org.goplanit.utils.zoning.Centroid;
import org.goplanit.utils.zoning.Connectoid;

public class ConnectoidEdgeImpl
extends DirectedEdgeImpl<DirectedVertex, EdgeSegment>
implements ConnectoidEdge {
    private static final long serialVersionUID = 1212317697383702580L;
    private static final Logger LOGGER = Logger.getLogger(ConnectoidEdgeImpl.class.getCanonicalName());
    protected long connectoidEdgeId;

    protected static long generateConnectoidEdgeId(IdGroupingToken tokenId) {
        return IdGenerator.generateId((IdGroupingToken)tokenId, Connectoid.class);
    }

    protected void setConnectoidEdgeId(long connectoidEdgeId) {
        this.connectoidEdgeId = connectoidEdgeId;
    }

    protected long recreateConnectoidEdgeId(IdGroupingToken tokenId) {
        long newConnectoidEdgeId = ConnectoidEdgeImpl.generateConnectoidEdgeId(tokenId);
        this.setConnectoidEdgeId(newConnectoidEdgeId);
        return newConnectoidEdgeId;
    }

    protected ConnectoidEdgeImpl(IdGroupingToken groupId, CentroidVertex centroidA, DirectedVertex vertexB, double length) {
        super(groupId, centroidA, vertexB, length);
        this.setConnectoidEdgeId(ConnectoidEdgeImpl.generateConnectoidEdgeId(groupId));
    }

    protected ConnectoidEdgeImpl(ConnectoidEdgeImpl other, boolean deepCopy) {
        super(other, deepCopy);
        this.setConnectoidEdgeId(other.getConnectoidEdgeId());
    }

    public boolean populateGeometry(boolean overwrite) {
        boolean success = super.populateBasicGeometry(overwrite);
        if (success) {
            return success;
        }
        Centroid centroid = this.getCentroidVertex().getParent();
        if (centroid == null) {
            return false;
        }
        if (centroid.hasPosition()) {
            LOGGER.severe("Centroid has position, yet populating basic geometry via Edge failed, this shouldn't happen");
            return false;
        }
        if (centroid.getParentZone() == null || !centroid.getParentZone().hasGeometry()) {
            return false;
        }
        return false;
    }

    @Override
    public long recreateManagedIds(IdGroupingToken tokenId) {
        this.recreateConnectoidEdgeId(tokenId);
        return super.recreateManagedIds(tokenId);
    }

    public ConnectoidSegment registerConnectoidSegment(ConnectoidSegment connectoidSegment, boolean directionAB) {
        return (ConnectoidSegment)this.registerEdgeSegment((EdgeSegment)connectoidSegment, directionAB);
    }

    public long getConnectoidEdgeId() {
        return this.connectoidEdgeId;
    }

    @Override
    public ConnectoidEdgeImpl shallowClone() {
        return new ConnectoidEdgeImpl(this, false);
    }

    @Override
    public ConnectoidEdgeImpl deepClone() {
        return new ConnectoidEdgeImpl(this, true);
    }
}

