/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.virtual;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.network.virtual.ConjugateConnectoidEdgesImpl;
import org.goplanit.network.virtual.ConjugateConnectoidNodesImpl;
import org.goplanit.network.virtual.ConjugateConnectoidSegmentsImpl;
import org.goplanit.utils.graph.directed.ConjugateDirectedEdge;
import org.goplanit.utils.graph.directed.DirectedEdge;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.virtual.CentroidVertex;
import org.goplanit.utils.network.virtual.ConjugateConnectoidEdge;
import org.goplanit.utils.network.virtual.ConjugateConnectoidEdges;
import org.goplanit.utils.network.virtual.ConjugateConnectoidNode;
import org.goplanit.utils.network.virtual.ConjugateConnectoidNodes;
import org.goplanit.utils.network.virtual.ConjugateConnectoidSegments;
import org.goplanit.utils.network.virtual.ConjugateVirtualNetwork;
import org.goplanit.utils.network.virtual.ConnectoidEdge;
import org.goplanit.utils.network.virtual.VirtualNetwork;

public class ConjugateVirtualNetworkImpl
implements ConjugateVirtualNetwork {
    private static final Logger LOGGER = Logger.getLogger(ConjugateVirtualNetworkImpl.class.getCanonicalName());
    protected final ConjugateConnectoidNodesImpl conjugateConnectoidNodes;
    protected final ConjugateConnectoidEdgesImpl conjugateConnectoidEdges;
    protected final ConjugateConnectoidSegmentsImpl conjugateConnectoidSegments;
    protected final VirtualNetwork originalVirtualNetwork;

    protected void update() {
        this.reset();
        HashMap<CentroidVertex, ConjugateConnectoidNode> dummyConjugatePerZone = new HashMap<CentroidVertex, ConjugateConnectoidNode>();
        for (ConnectoidEdge connectoidEdge : this.originalVirtualNetwork.getConnectoidEdges()) {
            CentroidVertex centroid = connectoidEdge.getCentroidVertex();
            ConjugateConnectoidNode conjugateDummyNode = (ConjugateConnectoidNode)dummyConjugatePerZone.get(centroid);
            if (conjugateDummyNode == null) {
                conjugateDummyNode = this.getConjugateConnectoidNodes().getFactory().registerNew(null);
                dummyConjugatePerZone.put(centroid, conjugateDummyNode);
            }
            ConjugateConnectoidNode conjugateNode = this.getConjugateConnectoidNodes().getFactory().registerNew(connectoidEdge);
            ConjugateConnectoidEdge conjugateEdge = this.getConjugateConnectoidEdges().getFactory().registerNew(conjugateDummyNode, conjugateNode, true, connectoidEdge);
            this.getConjugateConnectoidEdgeSegments().getFactory().registerNew(conjugateEdge, true, true);
            this.getConjugateConnectoidEdgeSegments().getFactory().registerNew(conjugateEdge, false, true);
        }
    }

    public ConjugateConnectoidNodes getConjugateConnectoidNodes() {
        return this.conjugateConnectoidNodes;
    }

    public ConjugateConnectoidEdges getConjugateConnectoidEdges() {
        return this.conjugateConnectoidEdges;
    }

    public ConjugateConnectoidSegments getConjugateConnectoidEdgeSegments() {
        return this.conjugateConnectoidSegments;
    }

    public ConjugateVirtualNetworkImpl(IdGroupingToken idToken, VirtualNetwork originalVirtualNetwork) {
        this.conjugateConnectoidNodes = new ConjugateConnectoidNodesImpl(idToken);
        this.conjugateConnectoidEdges = new ConjugateConnectoidEdgesImpl(idToken);
        this.conjugateConnectoidSegments = new ConjugateConnectoidSegmentsImpl(idToken);
        this.originalVirtualNetwork = originalVirtualNetwork;
    }

    public void clear() {
        this.conjugateConnectoidNodes.clear();
    }

    public void reset() {
        this.conjugateConnectoidNodes.reset();
    }

    public VirtualNetwork getOriginalVirtualNetwork() {
        return this.originalVirtualNetwork;
    }

    public Map<CentroidVertex, ConjugateConnectoidNode> createCentroidToConjugateNodeMapping() {
        HashMap<CentroidVertex, ConjugateConnectoidNode> mapping = new HashMap<CentroidVertex, ConjugateConnectoidNode>();
        for (ConjugateConnectoidNode conjugateNode : this.getConjugateConnectoidNodes()) {
            DirectedEdge originalEdge = conjugateNode.getOriginalEdge();
            if (originalEdge != null) continue;
            ConjugateDirectedEdge conjugateDummyEdge = (ConjugateDirectedEdge)conjugateNode.getEdges().iterator().next();
            ConnectoidEdge originalConnectoidEdge = (ConnectoidEdge)conjugateDummyEdge.getOriginalAdjacentEdges().getEarliestNonNull();
            if (originalConnectoidEdge == null) {
                LOGGER.severe(String.format("Conjugate connectoid dummy node's (%s) not connected to original centroid, this shouldn't happen", conjugateNode.getXmlId()));
            }
            mapping.put(originalConnectoidEdge.getCentroidVertex(), conjugateNode);
        }
        return mapping;
    }
}

