/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.virtual;

import java.util.logging.Logger;
import org.goplanit.graph.GraphEntityFactoryImpl;
import org.goplanit.network.virtual.ConjugateConnectoidEdgeImpl;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.GraphEntities;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.virtual.ConjugateConnectoidEdge;
import org.goplanit.utils.network.virtual.ConjugateConnectoidEdgeFactory;
import org.goplanit.utils.network.virtual.ConjugateConnectoidNode;
import org.goplanit.utils.network.virtual.ConnectoidEdge;

public class ConjugateConnectoidEdgeFactoryImpl
extends GraphEntityFactoryImpl<ConjugateConnectoidEdge>
implements ConjugateConnectoidEdgeFactory {
    private static final Logger LOGGER = Logger.getLogger(ConjugateConnectoidEdgeFactoryImpl.class.getCanonicalName());

    public ConjugateConnectoidEdgeFactoryImpl(IdGroupingToken groupIdToken, GraphEntities<ConjugateConnectoidEdge> container) {
        super(groupIdToken, container);
    }

    public ConjugateConnectoidEdge registerNew(ConjugateConnectoidNode vertexA, ConjugateConnectoidNode vertexB, boolean registerOnNodes, ConnectoidEdge originalConnectoidEdge) {
        if (vertexA == null || vertexB == null) {
            LOGGER.warning("Unable to create new conjugate link, one or more of its conjugate nodes are not defined");
            return null;
        }
        ConjugateConnectoidEdgeImpl newConjugateEdge = new ConjugateConnectoidEdgeImpl(this.getIdGroupingToken(), vertexA, vertexB, originalConnectoidEdge);
        this.getGraphEntities().register((Object)newConjugateEdge);
        if (registerOnNodes) {
            vertexA.addEdge((Edge)newConjugateEdge);
            vertexB.addEdge((Edge)newConjugateEdge);
        }
        return newConjugateEdge;
    }
}

