/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.virtual;

import org.goplanit.graph.directed.DirectedVertexImpl;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.virtual.CentroidVertex;
import org.goplanit.utils.network.virtual.ConnectoidSegment;
import org.goplanit.utils.zoning.Centroid;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class CentroidVertexImpl
extends DirectedVertexImpl<ConnectoidSegment>
implements CentroidVertex {
    private Centroid parent;

    protected CentroidVertexImpl(IdGroupingToken groupId, Centroid parentCentroid) {
        super(groupId);
        this.parent = parentCentroid;
    }

    protected CentroidVertexImpl(DirectedVertexImpl<ConnectoidSegment> other, boolean deepCopy) {
        super(other, deepCopy);
    }

    public Centroid getParent() {
        return this.parent;
    }

    public void setParent(Centroid parent) {
        this.parent = parent;
    }

    @Override
    public Point getPosition() {
        if (this.position != null && this.parent.hasPosition() && this.position.equals((Geometry)this.parent.getPosition())) {
            LOGGER.warning("Collecting position for centroid vertex, but its position and that of its parent centroid differ, this shouldn't happen");
        }
        if (this.position != null) {
            return this.position;
        }
        return this.getParent().getPosition();
    }

    @Override
    public void setPosition(Point position) {
        if (this.getParent().hasPosition()) {
            LOGGER.warning("IGNORE: Not allowed to overwrite position of centroid vertex, when parent centroid position exists");
        } else {
            this.position = position;
        }
    }
}

