/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.transport;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.network.LayeredNetwork;
import org.goplanit.network.TopologicalLayerNetwork;
import org.goplanit.network.layer.macroscopic.MacroscopicNetworkLayerImpl;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.network.layer.physical.UntypedPhysicalLayer;
import org.goplanit.utils.network.virtual.CentroidVertex;
import org.goplanit.utils.network.virtual.CentroidVertexFactory;
import org.goplanit.utils.network.virtual.ConnectoidEdge;
import org.goplanit.utils.network.virtual.ConnectoidEdgeFactory;
import org.goplanit.utils.network.virtual.ConnectoidSegment;
import org.goplanit.utils.network.virtual.ConnectoidSegmentFactory;
import org.goplanit.utils.network.virtual.VirtualNetwork;
import org.goplanit.utils.zoning.Centroid;
import org.goplanit.utils.zoning.Connectoid;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.utils.zoning.OdZone;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.UndirectedConnectoid;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.zoning.Zoning;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.linearref.LinearLocation;

public class TransportModelNetwork {
    private static final Logger LOGGER = Logger.getLogger(TransportModelNetwork.class.getCanonicalName());
    protected final TopologicalLayerNetwork<?, ?> infrastructureNetwork;
    protected final Zoning zoning;

    private void logInfo() {
        LOGGER.info(String.format("#OD connectoid edges: %d", this.getVirtualNetwork().getConnectoidEdges().size()));
        LOGGER.info(String.format("#OD connectoid segments: %d", this.getVirtualNetwork().getConnectoidSegments().size()));
    }

    protected void connectVerticesToEdge(Edge edge) {
        edge.getVertexA().addEdge(edge);
        edge.getVertexB().addEdge(edge);
    }

    protected void disconnectVerticesFromEdge(Edge edge) {
        edge.getVertexA().removeEdge(edge);
        edge.getVertexB().removeEdge(edge);
    }

    protected void createAndRegisterConnectoidEdgeSegments(ConnectoidSegmentFactory connectoidSegmentFactory, ConnectoidEdge connectoidEdge) {
        ConnectoidSegment segment = connectoidSegmentFactory.registerNew(connectoidEdge, true);
        segment.setXmlId("c_ab" + segment.getId());
        segment = connectoidSegmentFactory.registerNew(connectoidEdge, false);
        segment.setXmlId("c_ba" + segment.getId());
        this.connectVerticesToEdge((Edge)connectoidEdge);
    }

    protected void createAndRegisterConnectoidEdgeAndEdgeSegments(ConnectoidEdgeFactory connectoidEdgeFactory, ConnectoidSegmentFactory connectoidSegmentFactory, CentroidVertex centroidVertex, Zone accessZone, Connectoid connectoid, PlanitJtsCrsUtils geoTools) {
        double connectoidLength = (Double)connectoid.getLengthKm(accessZone).orElseThrow(() -> new PlanItRunTimeException("unable to retrieve length for connectoid %s (id:%d)", new Object[]{connectoid.getXmlId(), connectoid.getId()}));
        ConnectoidEdge connectoidEdge = connectoidEdgeFactory.registerNew(centroidVertex, connectoid.getAccessVertex(), connectoidLength);
        this.connectVerticesToEdge((Edge)connectoidEdge);
        this.createAndRegisterConnectoidEdgeSegments(connectoidSegmentFactory, connectoidEdge);
        this.populateConnectoidGeometry(connectoidEdge, geoTools);
    }

    private boolean populateConnectoidGeometry(ConnectoidEdge connectoidEdge, PlanitJtsCrsUtils geoTools) {
        Zone parentZone;
        CentroidVertex centroidVertex = connectoidEdge.getCentroidVertex();
        Centroid parentCentroid = centroidVertex.getParent();
        boolean connectoidHasGeometry = connectoidEdge.hasGeometry();
        if (!connectoidHasGeometry && parentCentroid.hasPosition()) {
            connectoidHasGeometry = connectoidEdge.populateBasicGeometry(true);
        }
        Zone zone = parentZone = parentCentroid != null ? parentCentroid.getParentZone() : null;
        if (!connectoidHasGeometry && parentZone != null && parentZone.hasGeometry()) {
            Geometry zoneGeometry = parentZone.getGeometry();
            if (zoneGeometry instanceof Point) {
                centroidVertex.setPosition((Point)zoneGeometry);
                return connectoidEdge.populateBasicGeometry(true);
            }
            if (zoneGeometry instanceof Polygon) {
                zoneGeometry = PlanitJtsUtils.createLineString((Coordinate[])((Polygon)zoneGeometry).getExteriorRing().getCoordinates());
            }
            if (!(zoneGeometry instanceof LineString)) {
                return false;
            }
            if (connectoidEdge.getNonCentroidVertex() == null || !connectoidEdge.getNonCentroidVertex().hasPosition()) {
                return false;
            }
            LinearLocation projectedLocation = geoTools.getClosestProjectedLinearLocationOnLineString(connectoidEdge.getNonCentroidVertex().getPosition().getCoordinate(), (LineString)zoneGeometry);
            Point closestPointOnZoneGeometry = PlanitJtsUtils.createPoint((Coordinate)projectedLocation.getCoordinate(zoneGeometry));
            connectoidEdge.setGeometry(PlanitJtsUtils.createLineString((Coordinate[])new Coordinate[]{closestPointOnZoneGeometry.getCoordinate(), connectoidEdge.getNonCentroidVertex().getPosition().getCoordinate()}));
            connectoidHasGeometry = true;
        }
        return connectoidHasGeometry;
    }

    public static int getNumberOfEdgeSegmentsAllLayers(LayeredNetwork<?, ?> theNetwork, Zoning theZoning) {
        return TransportModelNetwork.getNumberOfPhysicalLinkSegmentsAllLayers(theNetwork) + TransportModelNetwork.getNumberOfConnectoidSegments(theZoning);
    }

    public static int getNumberOfConnectoidSegments(Zoning theZoning) {
        return theZoning.getVirtualNetwork().getConnectoidSegments().size();
    }

    public static int getNumberOfPhysicalLinkSegmentsAllLayers(LayeredNetwork<?, ?> theNetwork) {
        int totalPhysicalLinkSegments = 0;
        Collection networkLayers = theNetwork.getTransportLayers().getLayersOfType();
        for (MacroscopicNetworkLayerImpl layer : networkLayers) {
            totalPhysicalLinkSegments = (int)((long)totalPhysicalLinkSegments + layer.getNumberOfLinkSegments());
        }
        return totalPhysicalLinkSegments;
    }

    public static int getNumberOfVerticesAllLayers(LayeredNetwork<?, ?> physicalNetwork, Zoning zoning) {
        return zoning.getOdZones().getNumberOfCentroids() + zoning.getTransferZones().getNumberOfCentroids() + TransportModelNetwork.getNumberOfPhysicalNodesAllLayers(physicalNetwork);
    }

    public static int getNumberOfPhysicalNodesAllLayers(LayeredNetwork<?, ?> theNetwork) {
        int totalPhysicalNodes = 0;
        Collection networkLayers = theNetwork.getTransportLayers().getLayersOfType();
        for (UntypedPhysicalLayer layer : networkLayers) {
            totalPhysicalNodes = (int)((long)totalPhysicalNodes + layer.getNumberOfNodes());
        }
        return totalPhysicalNodes;
    }

    public TransportModelNetwork(TopologicalLayerNetwork<?, ?> infrastructureNetwork, Zoning zoning) {
        this.infrastructureNetwork = infrastructureNetwork;
        this.zoning = zoning;
    }

    public TransportModelNetwork integrateTransportNetworkViaConnectoids() {
        CentroidVertex centroidVertex;
        LOGGER.info(String.format("Integrating physical network %d (XML id %s) with zoning %d (XML id %s)", this.infrastructureNetwork.getId(), this.infrastructureNetwork.getXmlId() != null ? this.infrastructureNetwork.getXmlId() : "N/A", this.zoning.getId(), this.zoning.getXmlId() != null ? this.zoning.getXmlId() : "N/A"));
        VirtualNetwork virtualNetwork = this.zoning.getVirtualNetwork();
        CentroidVertexFactory centroidVertexFactory = virtualNetwork.getCentroidVertices().getFactory();
        ConnectoidEdgeFactory connectoidEdgeFactory = virtualNetwork.getConnectoidEdges().getFactory();
        ConnectoidSegmentFactory connectoidSegmentFactory = virtualNetwork.getConnectoidSegments().getFactory();
        PlanitJtsCrsUtils geoTools = new PlanitJtsCrsUtils(this.getInfrastructureNetwork().getCoordinateReferenceSystem());
        HashMap<Zone, CentroidVertex> zone2CentroidVertexMapping = new HashMap<Zone, CentroidVertex>();
        for (UndirectedConnectoid undirectedConnectoid : this.zoning.getOdConnectoids()) {
            for (Zone accessZone : undirectedConnectoid.getAccessZones()) {
                centroidVertex = (CentroidVertex)zone2CentroidVertexMapping.get(accessZone);
                if (centroidVertex == null) {
                    centroidVertex = centroidVertexFactory.registerNew(accessZone.getCentroid());
                    zone2CentroidVertexMapping.put(accessZone, centroidVertex);
                }
                this.createAndRegisterConnectoidEdgeAndEdgeSegments(connectoidEdgeFactory, connectoidSegmentFactory, centroidVertex, accessZone, (Connectoid)undirectedConnectoid, geoTools);
            }
        }
        for (DirectedConnectoid directedConnectoid : this.zoning.getTransferConnectoids()) {
            for (Zone accessZone : directedConnectoid.getAccessZones()) {
                LinkSegment accessEdgeSegment;
                Node accessVertex;
                centroidVertex = (CentroidVertex)zone2CentroidVertexMapping.get(accessZone);
                if (centroidVertex == null) {
                    centroidVertex = centroidVertexFactory.registerNew(accessZone.getCentroid());
                    zone2CentroidVertexMapping.put(accessZone, centroidVertex);
                }
                Node node = accessVertex = (accessEdgeSegment = directedConnectoid.getAccessLinkSegment()) != null ? accessEdgeSegment.getDownstreamVertex() : null;
                if (accessVertex == null) {
                    throw new PlanItRunTimeException("No access vertex found for directed connectoid, this shouldn't happen");
                }
                this.createAndRegisterConnectoidEdgeAndEdgeSegments(connectoidEdgeFactory, connectoidSegmentFactory, centroidVertex, accessZone, (Connectoid)directedConnectoid, geoTools);
            }
        }
        this.logInfo();
        return this;
    }

    public int getNumberOfEdgeSegmentsAllLayers() {
        return TransportModelNetwork.getNumberOfPhysicalLinkSegmentsAllLayers(this.getInfrastructureNetwork()) + TransportModelNetwork.getNumberOfConnectoidSegments(this.getZoning());
    }

    public int getNumberOfPhysicalLinkSegmentsAllLayers() {
        return TransportModelNetwork.getNumberOfPhysicalLinkSegmentsAllLayers(this.getInfrastructureNetwork());
    }

    public int getNumberOfConnectoidSegments() {
        return this.zoning.getVirtualNetwork().getConnectoidSegments().size();
    }

    public int getNumberOfVerticesAllLayers() {
        return TransportModelNetwork.getNumberOfVerticesAllLayers(this.getInfrastructureNetwork(), this.zoning);
    }

    public int getNumberOfPhysicalNodesAllLayers() {
        return TransportModelNetwork.getNumberOfPhysicalNodesAllLayers(this.getInfrastructureNetwork());
    }

    public void removeVirtualNetworkFromPhysicalNetwork() {
        for (ConnectoidEdge connectoidEdge : this.zoning.getVirtualNetwork().getConnectoidEdges()) {
            this.disconnectVerticesFromEdge((Edge)connectoidEdge);
        }
        this.zoning.getVirtualNetwork().clear();
    }

    public TopologicalLayerNetwork<?, ?> getInfrastructureNetwork() {
        return this.infrastructureNetwork;
    }

    public VirtualNetwork getVirtualNetwork() {
        return this.zoning.getVirtualNetwork();
    }

    public Zoning getZoning() {
        return this.zoning;
    }

    public Map<Zone, CentroidVertex> createZoneToCentroidVertexMapping(boolean OdZones2, boolean transferZones) {
        return this.getZoning().getVirtualNetwork().getCentroidVertices().stream().filter(cVertex -> OdZones2 && cVertex.getParent().getParentZone() instanceof OdZone || transferZones && cVertex.getParent().getParentZone() instanceof TransferZone).collect(Collectors.toMap(cVertex -> cVertex.getParent().getParentZone(), cVertex -> cVertex));
    }
}

