/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layers;

import java.util.function.BiConsumer;
import java.util.logging.Logger;
import org.goplanit.utils.id.IdAble;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.id.ManagedIdEntitiesImpl;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.NetworkLayer;
import org.goplanit.utils.network.layers.NetworkLayers;

public abstract class TransportLayersImpl<T extends NetworkLayer>
extends ManagedIdEntitiesImpl<T>
implements NetworkLayers<T> {
    private static final Logger LOGGER = Logger.getLogger(TransportLayersImpl.class.getCanonicalName());
    private final IdGroupingToken idToken;

    protected IdGroupingToken getIdToken() {
        return this.idToken;
    }

    public TransportLayersImpl(IdGroupingToken idToken) {
        super(IdAble::getId, NetworkLayer.NETWORK_LAYER_ID_CLASS);
        this.idToken = idToken;
    }

    public TransportLayersImpl(TransportLayersImpl<T> other, boolean deepCopy, BiConsumer<T, T> mapper) {
        super(other, deepCopy, mapper);
        this.idToken = other.idToken;
    }

    public T get(Mode mode) {
        return (T)((NetworkLayer)this.firstMatch(layer -> layer.supports(mode)));
    }

    public T getByXmlId(String xmlId) {
        return (T)((NetworkLayer)this.firstMatch(layer -> layer.getXmlId().equals(xmlId)));
    }

    public abstract TransportLayersImpl<T> shallowClone();

    public abstract TransportLayersImpl<T> deepClone();

    public abstract TransportLayersImpl<T> deepCloneWithMapping(BiConsumer<T, T> var1);
}

