/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer.service;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.goplanit.graph.directed.DirectedVertexImpl;
import org.goplanit.utils.containers.ListUtils;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.IteratorUtils;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.network.layer.service.ServiceLegSegment;
import org.goplanit.utils.network.layer.service.ServiceNode;
import org.locationtech.jts.geom.Point;

public class ServiceNodeImpl
extends DirectedVertexImpl<ServiceLegSegment>
implements ServiceNode {
    private static final long serialVersionUID = 3704157577170156850L;
    private static final Logger LOGGER = Logger.getLogger(ServiceNodeImpl.class.getCanonicalName());

    protected Stream<Node> getEntrySegmentsDownstreamPhysicalNodeStream() {
        return IteratorUtils.asStream(this.getEntryEdgeSegments().iterator()).filter(e -> e.hasPhysicalParentSegments()).map(e -> ((LinkSegment)ListUtils.getLastValue((List)e.getPhysicalParentSegments())).getDownstreamNode());
    }

    protected Stream<Node> getExitSegmentsUpstreamPhysicalNodeStream() {
        return IteratorUtils.asStream(this.getExitEdgeSegments().iterator()).filter(e -> e.hasPhysicalParentSegments()).map(e -> ((LinkSegment)ListUtils.getFirstValue((List)e.getPhysicalParentSegments())).getUpstreamNode());
    }

    protected ServiceNodeImpl(IdGroupingToken tokenId) {
        super(tokenId);
    }

    protected ServiceNodeImpl(ServiceNodeImpl other, boolean deepCopy) {
        super(other, deepCopy);
    }

    @Override
    public final Point getPosition() {
        Collection physicalParentNodes = this.getPhysicalParentNodes();
        if (physicalParentNodes.isEmpty()) {
            LOGGER.warning(String.format("No physical parent nodes available on service node (%s), position unknown", this.getIdsAsString()));
            return null;
        }
        if (physicalParentNodes.size() == 1) {
            Node parentNode = (Node)physicalParentNodes.iterator().next();
            if (parentNode.hasPosition()) {
                return (Point)((Node)physicalParentNodes.iterator().next()).getPosition().copy();
            }
            return null;
        }
        Double averageX = physicalParentNodes.stream().filter(n -> n.hasPosition()).collect(Collectors.averagingDouble(n -> n.getPosition().getCoordinate().x));
        Double averageY = physicalParentNodes.stream().filter(n -> n.hasPosition()).collect(Collectors.averagingDouble(n -> n.getPosition().getCoordinate().y));
        return PlanitJtsUtils.createPoint((Number)averageX, (Number)averageY);
    }

    @Override
    public void setPosition(Point position) {
        LOGGER.warning("Unable to modify position, physical network node indirectly determines position of service node");
    }

    public final Set<Node> getPhysicalParentNodes() {
        return Stream.concat(this.getExitSegmentsUpstreamPhysicalNodeStream(), this.getEntrySegmentsDownstreamPhysicalNodeStream()).collect(Collectors.toSet());
    }

    public boolean hasPhysicalParentNodes() {
        return this.getExitSegmentsUpstreamPhysicalNodeStream().findFirst().isPresent() || this.getEntrySegmentsDownstreamPhysicalNodeStream().findFirst().isPresent();
    }

    @Override
    public ServiceNodeImpl shallowClone() {
        return new ServiceNodeImpl(this, false);
    }

    @Override
    public ServiceNodeImpl deepClone() {
        return new ServiceNodeImpl(this, true);
    }

    public boolean isMappedToPhysicalParentNode(Node physicalParentNode) {
        boolean match = this.getExitSegmentsUpstreamPhysicalNodeStream().anyMatch(e -> e.equals(physicalParentNode));
        if (match) {
            return true;
        }
        return this.getEntrySegmentsDownstreamPhysicalNodeStream().anyMatch(e -> e.equals(physicalParentNode));
    }
}

