/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer.service;

import java.util.Collection;
import java.util.logging.Logger;
import org.goplanit.network.layer.UntypedNetworkLayerImpl;
import org.goplanit.network.layer.modifier.ServiceNetworkLayerModifierImpl;
import org.goplanit.network.layer.service.ServiceLegSegmentsImpl;
import org.goplanit.network.layer.service.ServiceLegsImpl;
import org.goplanit.network.layer.service.ServiceNodesImpl;
import org.goplanit.utils.graph.GraphEntityDeepCopyMapper;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.ServiceNetworkLayer;
import org.goplanit.utils.network.layer.service.ServiceLeg;
import org.goplanit.utils.network.layer.service.ServiceLegSegment;
import org.goplanit.utils.network.layer.service.ServiceLegSegments;
import org.goplanit.utils.network.layer.service.ServiceLegs;
import org.goplanit.utils.network.layer.service.ServiceNode;
import org.goplanit.utils.network.layer.service.ServiceNodes;

public class ServiceNetworkLayerImpl
extends UntypedNetworkLayerImpl<ServiceNode, ServiceLeg, ServiceLegSegment>
implements ServiceNetworkLayer {
    private static final Logger LOGGER = Logger.getLogger(ServiceNetworkLayerImpl.class.getCanonicalName());
    protected MacroscopicNetworkLayer parentNetworkLayer;

    protected void setParentNetworkLayer(MacroscopicNetworkLayer parentNetworkLayer) {
        this.parentNetworkLayer = parentNetworkLayer;
    }

    protected ServiceNetworkLayerImpl(IdGroupingToken tokenId) {
        this(tokenId, null);
    }

    protected ServiceNetworkLayerImpl(IdGroupingToken tokenId, MacroscopicNetworkLayer parentLayer) {
        this(tokenId, parentLayer, new ServiceNodesImpl(tokenId), new ServiceLegsImpl(tokenId), new ServiceLegSegmentsImpl(tokenId));
    }

    protected ServiceNetworkLayerImpl(IdGroupingToken tokenId, MacroscopicNetworkLayer parentNetworkLayer, ServiceNodes nodes, ServiceLegs legs, ServiceLegSegments legSegments) {
        super(tokenId, nodes, legs, legSegments);
        this.layerModifier = new ServiceNetworkLayerModifierImpl(this, this.directedGraph);
        this.parentNetworkLayer = parentNetworkLayer;
    }

    public ServiceNetworkLayerImpl(ServiceNetworkLayerImpl other, boolean deepCopy, GraphEntityDeepCopyMapper<ServiceNode> nodeMapper, GraphEntityDeepCopyMapper<ServiceLeg> legMapper, GraphEntityDeepCopyMapper<ServiceLegSegment> legSegmentMapper) {
        super(other, deepCopy, nodeMapper, legMapper, legSegmentMapper);
        this.parentNetworkLayer = other.parentNetworkLayer;
        this.layerModifier = new ServiceNetworkLayerModifierImpl(this, this.directedGraph);
    }

    public final ServiceLegs getLegs() {
        return (ServiceLegs)this.getDirectedGraph().getEdges();
    }

    public final ServiceLegSegments getLegSegments() {
        return (ServiceLegSegments)this.getDirectedGraph().getEdgeSegments();
    }

    public final ServiceNodes getServiceNodes() {
        return (ServiceNodes)this.getDirectedGraph().getVertices();
    }

    public MacroscopicNetworkLayer getParentNetworkLayer() {
        return this.parentNetworkLayer;
    }

    @Override
    public void logInfo(String prefix) {
        super.logInfo(prefix);
        LOGGER.info(String.format("%s#service legs: %d", prefix, this.getLegs().size()));
        LOGGER.info(String.format("%s#service leg segments: %d", prefix, this.getLegSegments().size()));
        LOGGER.info(String.format("%s#service nodes: %d", prefix, this.getServiceNodes().size()));
    }

    @Override
    public boolean registerSupportedMode(Mode supportedMode) {
        LOGGER.warning(String.format("Unable to register additional supported modes on service network layer %s, do so on parent network layer %s instead", this.getXmlId(), this.getParentNetworkLayer().getXmlId()));
        return false;
    }

    @Override
    public boolean registerSupportedModes(Collection<Mode> supportedModes) {
        LOGGER.warning(String.format("Unable to register additional supported modes on service network layer %s, do so on parent network layer %s instead", this.getXmlId(), this.getParentNetworkLayer().getXmlId()));
        return false;
    }

    @Override
    public Collection<Mode> getSupportedModes() {
        return this.getParentNetworkLayer().getSupportedModes();
    }

    public boolean supports(Mode mode) {
        return this.getParentNetworkLayer().supports(mode);
    }

    @Override
    public ServiceNetworkLayerModifierImpl<ServiceNode, ServiceLeg, ServiceLegSegment> getLayerModifier() {
        return (ServiceNetworkLayerModifierImpl)super.getLayerModifier();
    }

    @Override
    public ServiceNetworkLayerImpl shallowClone() {
        return new ServiceNetworkLayerImpl(this, false, null, null, null);
    }

    @Override
    public ServiceNetworkLayerImpl deepClone() {
        return new ServiceNetworkLayerImpl(this, true, (GraphEntityDeepCopyMapper<ServiceNode>)new GraphEntityDeepCopyMapper(), (GraphEntityDeepCopyMapper<ServiceLeg>)new GraphEntityDeepCopyMapper(), (GraphEntityDeepCopyMapper<ServiceLegSegment>)new GraphEntityDeepCopyMapper());
    }
}

