/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.graph.directed.EdgeSegmentImpl;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.network.layer.service.ServiceLeg;
import org.goplanit.utils.network.layer.service.ServiceLegSegment;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;

public class ServiceLegSegmentImpl
extends EdgeSegmentImpl<ServiceLeg>
implements ServiceLegSegment {
    private static final long serialVersionUID = 407229732625691579L;
    private static final Logger LOGGER = Logger.getLogger(ServiceLegSegmentImpl.class.getCanonicalName());
    protected List<? extends LinkSegment> networkLayerLinkSegments;

    protected ServiceLegSegmentImpl(IdGroupingToken tokenId, ServiceLeg parentLeg, boolean directionAB) {
        this(tokenId, parentLeg, directionAB, (List<LinkSegment>)null);
    }

    protected ServiceLegSegmentImpl(IdGroupingToken tokenId, ServiceLeg parentLeg, boolean directionAB, List<LinkSegment> networkLayerLinkSegments) {
        super(tokenId, parentLeg, directionAB);
        this.networkLayerLinkSegments = networkLayerLinkSegments;
    }

    protected ServiceLegSegmentImpl(ServiceLegSegmentImpl other, boolean deepCopy) {
        super(other, deepCopy);
        this.networkLayerLinkSegments = new ArrayList<LinkSegment>(other.networkLayerLinkSegments);
    }

    @Override
    public ServiceLeg getParent() {
        return (ServiceLeg)super.getParent();
    }

    public LineString getGeometry() {
        if (!this.hasGeometry()) {
            return null;
        }
        ArrayList<LineString> geometriesInDirectionOfTravel = new ArrayList<LineString>();
        int numCoordinates = 0;
        for (LinkSegment linkSegment : this.getPhysicalParentSegments()) {
            LineString segmentGeometry = linkSegment.getParentLink().getGeometry();
            if (!linkSegment.isDirectionAb()) {
                segmentGeometry = segmentGeometry.reverse();
            }
            geometriesInDirectionOfTravel.add(segmentGeometry);
            numCoordinates += segmentGeometry.getNumPoints();
        }
        Coordinate[] concatenatedCoordinates = (Coordinate[])geometriesInDirectionOfTravel.stream().flatMap(lsGeometry -> Arrays.stream(lsGeometry.getCoordinates())).toArray(Coordinate[]::new);
        return PlanitJtsUtils.createLineString((Coordinate[])concatenatedCoordinates);
    }

    public double getLengthKm() {
        if (this.networkLayerLinkSegments == null || this.networkLayerLinkSegments.isEmpty()) {
            return 0.0;
        }
        return this.networkLayerLinkSegments.stream().collect(Collectors.summingDouble(ls -> ls.getParent().getLengthKm()));
    }

    public boolean hasGeometry() {
        if (this.networkLayerLinkSegments == null || this.networkLayerLinkSegments.isEmpty()) {
            return false;
        }
        return this.networkLayerLinkSegments.stream().allMatch(ls -> ls.getParent().hasGeometry());
    }

    public List<? extends LinkSegment> getPhysicalParentSegments() {
        return this.networkLayerLinkSegments;
    }

    public void setPhysicalParentSegments(List<? extends LinkSegment> networkLayerLinkSegments) {
        this.networkLayerLinkSegments = networkLayerLinkSegments;
    }

    @Override
    public boolean validate() {
        boolean valid = super.validate();
        if (valid && this.hasPhysicalParentSegments()) {
            if (!this.getParent().getServiceNodeA().isMappedToPhysicalParentNode(this.isDirectionAb() ? this.getFirstPhysicalLinkSegment().getUpstreamNode() : this.getLastPhysicalLinkSegment().getDownstreamNode())) {
                LOGGER.severe(String.format("Service Node A (%s)'s physical node mapping on leg %s does not equate to physical node A (%s) of the first parent link (%s)", this.getParent().getServiceNodeA().getXmlId(), this.getXmlId(), this.getFirstPhysicalLinkSegment().getUpstreamNode().getXmlId(), this.getFirstPhysicalLinkSegment().getXmlId()));
                valid = false;
            }
            if (!this.getParent().getServiceNodeB().isMappedToPhysicalParentNode(this.isDirectionAb() ? this.getLastPhysicalLinkSegment().getDownstreamNode() : this.getFirstPhysicalLinkSegment().getUpstreamNode())) {
                LOGGER.severe(String.format("Service Node B's (%s) physical node on leg %s does not equate to node B (%s) of the last parent link (%s)", this.getParent().getServiceNodeB().getXmlId(), this.getXmlId(), this.getLastPhysicalLinkSegment().getDownstreamNode().getXmlId(), this.getLastPhysicalLinkSegment().getXmlId()));
                valid = false;
            }
        }
        return valid;
    }

    @Override
    public ServiceLegSegmentImpl shallowClone() {
        return new ServiceLegSegmentImpl(this, false);
    }

    @Override
    public ServiceLegSegmentImpl deepClone() {
        return new ServiceLegSegmentImpl(this, true);
    }
}

