/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer.service;

import java.util.logging.Logger;
import java.util.stream.DoubleStream;
import org.goplanit.graph.directed.DirectedEdgeImpl;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.network.layer.service.ServiceLeg;
import org.goplanit.utils.network.layer.service.ServiceLegSegment;
import org.goplanit.utils.network.layer.service.ServiceNode;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LineString;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class ServiceLegImpl
extends DirectedEdgeImpl<ServiceNode, ServiceLegSegment>
implements ServiceLeg {
    private static final long serialVersionUID = 822966574857604397L;
    private static final Logger LOGGER = Logger.getLogger(ServiceLegImpl.class.getCanonicalName());

    protected ServiceLegImpl(IdGroupingToken tokenId, ServiceNode nodeA, ServiceNode nodeB) {
        super(tokenId, nodeA, nodeB);
    }

    protected ServiceLegImpl(ServiceLegImpl other, boolean deepCopy) {
        super(other, deepCopy);
    }

    public boolean hasGeometry() {
        if (this.getLegSegments() == null || this.getLegSegments().isEmpty()) {
            return false;
        }
        return this.getLegSegments().stream().allMatch(ls -> ls.hasGeometry());
    }

    public boolean isGeometryInAbDirection() {
        throw new PlanItRunTimeException("Not possible to determine geometry direction unambiguously as geomtry is derived from service leg segments");
    }

    public void transformGeometry(MathTransform transformer) throws MismatchedDimensionException, TransformException {
        throw new TransformException("Not allowed to transform geometry on service leg since it holds no geometry. Consider transforming underlying parent links instead");
    }

    public Envelope createEnvelope() {
        if (this.getLegSegments() == null || this.getLegSegments().isEmpty()) {
            return null;
        }
        Envelope envelope = null;
        for (ServiceLegSegment legSegment : this.getLegSegments()) {
            for (LinkSegment linkSegment : legSegment.getPhysicalParentSegments()) {
                if (!linkSegment.hasGeometry()) continue;
                if (envelope == null) {
                    envelope = linkSegment.getParentLink().createEnvelope();
                    continue;
                }
                envelope.expandToInclude(linkSegment.getParentLink().createEnvelope());
            }
        }
        return envelope;
    }

    @Override
    public LineString getGeometry() {
        if (this.getServiceNodeA() == null || this.getServiceNodeB() == null || !this.getServiceNodeA().hasPosition() || !this.getServiceNodeB().hasPosition()) {
            return null;
        }
        return PlanitJtsUtils.createLineString((Coordinate[])new Coordinate[]{this.getServiceNodeA().getPosition().getCoordinate(), this.getServiceNodeB().getPosition().getCoordinate()});
    }

    @Override
    public void setGeometry(LineString lineString) {
        LOGGER.warning("Not allowed to set geometry on service leg, do so on underlying links instead");
    }

    @Override
    public double getLengthKm() {
        return this.getLengthKm(ServiceLeg.LengthType.AVERAGE);
    }

    public double getLengthKm(ServiceLeg.LengthType lengthType) {
        double resultIfAbsent = 0.0;
        DoubleStream streamOfLinkSegmentLengths = this.getLegSegments().stream().mapToDouble(ls -> ls.getLengthKm());
        switch (lengthType) {
            case MAX: {
                return streamOfLinkSegmentLengths.max().orElse(resultIfAbsent);
            }
            case MIN: {
                return streamOfLinkSegmentLengths.min().orElse(resultIfAbsent);
            }
            case AVERAGE: {
                return streamOfLinkSegmentLengths.average().orElse(resultIfAbsent);
            }
        }
        LOGGER.warning(String.format("Unsupported length type %s when constructing length for service leg %s, revert to default %.2f", this.getIdsAsString(), resultIfAbsent));
        return resultIfAbsent;
    }

    @Override
    public void setLengthKm(double lengthInKm) {
        LOGGER.warning("Not allowed to set length on service leg, do so on underlying leg segment's physical links instead");
    }

    @Override
    public boolean validate() {
        boolean valid = super.validate();
        if (valid && this.hasEdgeSegment()) {
            for (ServiceLegSegment serviceLegSegment : this.getLegSegments()) {
                serviceLegSegment.validate();
            }
        }
        return true;
    }

    @Override
    public ServiceLegImpl shallowClone() {
        return new ServiceLegImpl(this, false);
    }

    @Override
    public ServiceLegImpl deepClone() {
        return new ServiceLegImpl(this, true);
    }
}

