/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer.physical;

import org.goplanit.graph.directed.EdgeSegmentImpl;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.network.layer.physical.Node;

public abstract class LinkSegmentBase<L extends Link>
extends EdgeSegmentImpl<L>
implements LinkSegment {
    private static final long serialVersionUID = -4893553215218232006L;
    protected long linkSegmentId;
    protected int numberOfLanes = 1;
    protected double physicalSpeedLinkKmh = 130.0;

    protected void setLinkSegmentId(long linkSegmentId) {
        this.linkSegmentId = linkSegmentId;
    }

    protected long recreateLinkSegmentId(IdGroupingToken tokenId) {
        long newLinkSegmentId = this.generateLinkSegmentId(tokenId);
        this.setLinkSegmentId(newLinkSegmentId);
        return newLinkSegmentId;
    }

    protected LinkSegmentBase(IdGroupingToken groupId, boolean directionAB) {
        this(groupId, null, directionAB);
    }

    protected LinkSegmentBase(IdGroupingToken groupId, L parentLink, boolean directionAB) {
        super(groupId, parentLink, directionAB);
        this.setLinkSegmentId(this.generateLinkSegmentId(groupId));
    }

    protected LinkSegmentBase(LinkSegmentBase<L> other, boolean deepCopy) {
        super(other, deepCopy);
        this.setLinkSegmentId(other.getLinkSegmentId());
        this.setNumberOfLanes(other.getNumberOfLanes());
        this.setPhysicalSpeedLimitKmH(other.getPhysicalSpeedLimitKmH());
    }

    @Override
    public long recreateManagedIds(IdGroupingToken tokenId) {
        this.recreateLinkSegmentId(tokenId);
        return super.recreateManagedIds(tokenId);
    }

    public long getLinkSegmentId() {
        return this.linkSegmentId;
    }

    @Override
    public L getParent() {
        return (L)((Link)super.getParent());
    }

    public Node getDownstreamVertex() {
        return (Node)super.getDownstreamVertex();
    }

    public Node getUpstreamVertex() {
        return (Node)super.getUpstreamVertex();
    }

    public int getNumberOfLanes() {
        return this.numberOfLanes;
    }

    public LinkSegment setNumberOfLanes(int numberOfLanes) {
        this.numberOfLanes = numberOfLanes;
        return this;
    }

    public LinkSegment setPhysicalSpeedLimitKmH(double maximumSpeed) {
        this.physicalSpeedLinkKmh = maximumSpeed;
        return this;
    }

    public double getPhysicalSpeedLimitKmH() {
        return this.physicalSpeedLinkKmh;
    }

    @Override
    public abstract LinkSegmentBase<L> shallowClone();

    @Override
    public abstract LinkSegmentBase<L> deepClone();
}

